<?php
require_once __DIR__ . '/../core/auth.php';
require_login(); // منع الدخول لغير المسجلين

$pdo = db();

// نحاول نقرأ بيانات المتجر من جدول stores أولاً، ثم restaurants كـ fallback
$store = null;
try {
  $stmt = $pdo->query("SELECT * FROM stores ORDER BY id DESC LIMIT 1");
  $store = $stmt->fetch();
} catch (Throwable $e) {
  try {
    $stmt = $pdo->query("SELECT * FROM restaurants ORDER BY id DESC LIMIT 1");
    $store = $stmt->fetch();
  } catch (Throwable $e2) {
    $store = null;
  }
}

// تطبيع الحقول حسب أكثر من اسم محتمل
$logo    = $store['logo']    ?? $store['Logo']       ?? null;
$nameAr  = $store['name']    ?? $store['CompanyName']   ?? 'بيانات المتجر';
$nameEn  = $store['name_en'] ?? $store['CompanyEName']  ?? 'إدارة معلومات المتجر';
$phone   = $store['phone']   ?? $store['Phone']      ?? null;
$website = $store['website'] ?? $store['Website']    ?? null;
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>لوحة التحكم - نظام الملابس</title>

  <!-- Bootstrap & FontAwesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <style>
    :root{
      /* ألوان افتراضية (الوضع الفاتح) */
      --bg: #f5f7fa;
      --text: #1f2937;
      --muted: #6b7280;
      --card-bg: #ffffff;
      --card-border: rgba(0,0,0,0.06);
      --brand-1: #0f2027;
      --brand-2: #203a43;
      --brand-3: #2c5364;
      --primary: #1abc9c;
      --primary-600:#16a085;
      --link:#3498db;

      --sidebar-bg:#2f3b46;
      --sidebar-item:#e8eef3;
      --sidebar-item-hover:#1abc9c;
      --sidebar-head:#22303a;
    }
    body.dark{
      /* ألوان الوضع الليلي */
      --bg: #0f1115;
      --text: #e5e7eb;
      --muted: #9ca3af;
      --card-bg: #151922;
      --card-border: rgba(255,255,255,0.08);
      --brand-1:#000;
      --brand-2:#111;
      --brand-3:#222;
      --primary:#16a085;
      --primary-600:#149174;
      --link:#60a5fa;
      --sidebar-bg:#141a22;
      --sidebar-item:#c7d2fe;
      --sidebar-item-hover:#1abc9c;
      --sidebar-head:#0f141a;
    }

    /* Reset & Base */
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0;
      background:var(--bg);
      color:var(--text);
      font-family:"Tajawal", Tahoma, Arial, sans-serif;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
    }
    a{color:var(--link); text-decoration:none}
    a:hover{text-decoration:underline}

    /* Header */
    header{
      background: linear-gradient(135deg,var(--brand-1),var(--brand-2),var(--brand-3));
      color:#fff;
      padding:14px 18px;
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:12px;
      box-shadow:0 6px 24px rgba(0,0,0,.25);
      position:sticky;
      top:0;
      z-index:1000;
    }
    header .title{
      display:flex; align-items:center; gap:10px; justify-content:center; flex:1;
      font-size:20px; font-weight:800; letter-spacing:.3px;
    }
    .user-info{
      display:flex; align-items:center; gap:10px;
      background:rgba(255,255,255,.1);
      padding:6px 10px; border-radius:999px;
      transition:.25s;
    }
    .user-info:hover{ background:rgba(255,255,255,.2); }
    .user-info img{
      width:36px; height:36px; border-radius:50%; object-fit:cover; border:2px solid var(--primary);
    }
    .user-info .name{ font-weight:700; font-size:13px; }
    .user-info .logout{
      background:#e74c3c; color:#fff; border:none; padding:6px 10px;
      border-radius:999px; font-size:12px; text-decoration:none;
    }
    .user-info .logout:hover{ background:#c0392b; }

    #darkSwitch{
      background:var(--primary);
      color:#fff; border:0; border-radius:999px; padding:8px 12px; font-weight:800; cursor:pointer;
      box-shadow:0 4px 12px rgba(0,0,0,.25);
    }
    #darkSwitch:hover{ background:var(--primary-600); }

    /* Layout */
    .wrap{
      display:flex; gap:18px;
      flex-direction: row-reverse; /* يخلي السايدبار يمين */
      padding:18px;
      min-height: calc(100vh - 64px);
    }

    /* Sidebar */
    .sidebar{
      width:280px; flex:0 0 280px;
      background:var(--sidebar-bg);
      border-radius:14px; padding:10px; color:#fff;
      height:fit-content; position:sticky; top:90px;
      box-shadow:0 10px 24px rgba(0,0,0,.18);
    }
    .sidebar .accordion-item{
      border:none; background:transparent; color:#fff; margin-bottom:8px;
    }
    .sidebar .accordion-button{
      background:var(--sidebar-head); color:#fff; border:none; border-radius:10px !important;
      padding:10px 12px; font-weight:800;
    }
    .sidebar .accordion-button:focus{ box-shadow:none; }
    .sidebar .accordion-button:not(.collapsed){
      background:var(--primary); color:#fff;
    }
    .sidebar .accordion-body{ padding:0 !important; }
    .sidebar .list-group{ border-radius:10px; overflow:hidden; }
    .sidebar .list-group-item{
      background:transparent; color:var(--sidebar-item);
      border:0; display:flex; align-items:center; gap:10px;
      padding:10px 14px; transition:.2s;
    }
    .sidebar .list-group-item:hover{
      background:rgba(255,255,255,.06); color:#fff;
    }
    .sidebar .list-group-item a{
      color:inherit; text-decoration:none; flex:1;
    }

    /* Main */
    main{ flex:1; }
    .page-head{
      display:flex; align-items:center; justify-content:space-between; gap:10px; margin-bottom:14px;
    }
    .page-head h2{ margin:0; font-size:20px; font-weight:800; }

    /* Cards */
    .cards{
      display:grid; gap:18px;
      grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    }
    .card-tile{
      background:var(--card-bg);
      border:1px solid var(--card-border);
      border-radius:16px;
      padding:16px;
      text-align:center;
      transition: transform .15s ease, box-shadow .2s ease, border-color .2s ease;
      box-shadow: 0 4px 14px rgba(0,0,0,.06);
    }
    .card-tile:hover{
      transform: translateY(-4px);
      box-shadow: 0 12px 30px rgba(0,0,0,.12);
      border-color: rgba(0,0,0,.12);
    }
    .tile-icon{
      width:64px; height:64px; border-radius:14px; display:flex; align-items:center; justify-content:center;
      margin:0 auto 10px auto; font-size:24px; color:#fff;
      background: linear-gradient(135deg, var(--primary), var(--primary-600));
    }
    .tile-title{ font-weight:800; color:var(--text); margin:8px 0 4px; }
    .tile-desc{ color:var(--muted); font-size:13px; min-height:34px; }
    .tile-action{
      display:inline-block; margin-top:10px; padding:8px 12px; border-radius:10px; font-weight:800;
      background:var(--primary); color:#fff; text-decoration:none;
    }
    .tile-action:hover{ background:var(--primary-600); color:#fff; text-decoration:none; }

    .tile-logo{
      width:64px; height:64px; border-radius:50%; object-fit:cover; border:3px solid var(--primary);
      display:block; margin:0 auto 10px;
    }

    @media (max-width: 992px){
      .wrap{ flex-direction:column; }
      .sidebar{ position:static; width:100%; flex:none; }
    }
  </style>
</head>
<body>

<header>
  <!-- يمين: المستخدم -->
  <div class="user-info">
    <img src="uploads/<?= htmlspecialchars($_SESSION['avatar'] ?? 'default.png') ?>" alt="Avatar">
    <span class="name"><?= htmlspecialchars($_SESSION['admin_username']) ?></span>
    <a class="logout" href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> خروج</a>
  </div>

  <!-- وسط: العنوان -->
  <div class="title"><i class="fa-solid fa-gauge-high"></i> لوحة التحكم - نظام الملابس</div>

  <!-- شمال: وضع ليلي -->
  <button id="darkSwitch">🌙</button>
</header>

<div class="wrap">

  <!-- Sidebar (يمين) -->
  <aside class="sidebar">
    <div class="accordion" id="menuAccordion">

      <!-- بيانات أساسية -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingBasic">
          <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseBasic" aria-expanded="true" aria-controls="collapseBasic">
            📊 بيانات أساسية
          </button>
        </h2>
        <div id="collapseBasic" class="accordion-collapse collapse show" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-store"></i><a href="storeinfo.php">بيانات المتجر</a></li>
              <li class="list-group-item"><i class="fa-solid fa-code-branch"></i><a href="branches.php">الفروع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-truck-field"></i><a href="suppliers.php">الموردون</a></li>
              <li class="list-group-item"><i class="fa-solid fa-user-group"></i><a href="customers.php">العملاء</a></li>
              <li class="list-group-item"><i class="fa-solid fa-id-badge"></i><a href="employees.php">الموظفون</a></li>
              <li class="list-group-item"><i class="fa-solid fa-users-gear"></i><a href="users.php">المستخدمون</a></li>
              <li class="list-group-item"><i class="fa-solid fa-layer-group"></i><a href="usergroups.php">المجاميع و الصلاحيات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-location-dot"></i><a href="governates.php">المحافظات وأسعار الشحن</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- نقطة البيع / المبيعات -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingPOS">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePOS" aria-expanded="false" aria-controls="collapsePOS">
            💻 نقطة البيع والمبيعات
          </button>
        </h2>
        <div id="collapsePOS" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-cash-register"></i><a href="pos/sale.php">بيع مباشر</a></li>
              <li class="list-group-item"><i class="fa-solid fa-file-invoice-dollar"></i><a href="sales.php">فواتير المبيعات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-rotate-left"></i><a href="sales_returns.php">مرتجعات المبيعات</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- المنتجات -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingItems">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseItems" aria-expanded="false" aria-controls="collapseItems">
            👕 المنتجات
          </button>
        </h2>
        <div id="collapseItems" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-folder-tree"></i><a href="categories.php">الأقسام والفئات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-shirt"></i><a href="products.php">المنتجات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-ruler-combined"></i><a href="variants.php">المقاسات والألوان</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- المخزون والتشغيل -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingOps">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOps" aria-expanded="false" aria-controls="collapseOps">
            📦 المخزون والتشغيل
          </button>
        </h2>
        <div id="collapseOps" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-boxes-stacked"></i><a href="inventory.php">المخزون</a></li>
              <li class="list-group-item"><i class="fa-solid fa-right-left"></i><a href="transfers.php">تحويلات بين الفروع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-calendar-day"></i><a href="stock_count.php">الجرد اليومي</a></li>
              <li class="list-group-item"><i class="fa-solid fa-clock-rotate-left"></i><a href="cashier_shift.php">الشيفتات</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- المشتريات -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingPurchases">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePurchases" aria-expanded="false" aria-controls="collapsePurchases">
            🧾 المشتريات
          </button>
        </h2>
        <div id="collapsePurchases" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-file-invoice"></i><a href="purchases.php">فواتير شراء</a></li>
              <li class="list-group-item"><i class="fa-solid fa-rotate"></i><a href="purchase_returns.php">مرتجعات شراء</a></li>
            </ul>
          </div>
        </div>
      </div>

      <!-- الإعدادات -->
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingSettings">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSettings" aria-expanded="false" aria-controls="collapseSettings">
            ⚙️ إعدادات
          </button>
        </h2>
        <div id="collapseSettings" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">
              <li class="list-group-item"><i class="fa-solid fa-sliders"></i><a href="settings.php">الإعدادات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-right-from-bracket"></i><a href="logout.php">تسجيل الخروج</a></li>
            </ul>
          </div>
        </div>
      </div>

            <!-- التقارير -->
            <div class="accordion-item">
        <h2 class="accordion-header" id="headingReports">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseReports" aria-expanded="false" aria-controls="collapseReports">
            📈 التقارير
          </button>
        </h2>
        <div id="collapseReports" class="accordion-collapse collapse" data-bs-parent="#menuAccordion">
          <div class="accordion-body">
            <ul class="list-group list-group-flush">

              <!-- المرحلة 1: أساسيات -->
              <li class="list-group-item text-muted"><i class="fa-solid fa-layer-group"></i> — المرحلة 1: أساسيات —</li>
              <li class="list-group-item"><i class="fa-solid fa-boxes-stacked"></i><a href="reports/stock_current.php">المخزون الحالي (فرع/فئة/مقاس/لون)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-bell"></i><a href="reports/reorder_alerts.php">تنبيهات إعادة الطلب (تحت الحدّ)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-calculator"></i><a href="reports/stock_valuation_cost.php">تقييم المخزون بسعر التكلفة</a></li>
              <li class="list-group-item"><i class="fa-solid fa-right-left"></i><a href="reports/inventory_movements.php">حركة المخزون (دخل/خرج)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-clipboard-check"></i><a href="reports/stock_count_variance.php">الجرد: الفاقد/الزيادة والقيمة</a></li>
              <li class="list-group-item"><i class="fa-solid fa-file-invoice-dollar"></i><a href="reports/purchases_summary.php">ملخص المشتريات</a></li>
              <li class="list-group-item"><i class="fa-regular fa-hourglass-half"></i><a href="reports/ap_aging.php">أعمار الذمم الدائنة (الموردون)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-rotate"></i><a href="reports/purchase_returns.php">مرتجعات الشراء</a></li>
              <li class="list-group-item"><i class="fa-solid fa-right-left"></i><a href="reports/transfers_report.php">تحويلات بين الفروع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-rotate-left"></i><a href="reports/sales_returns.php">مرتجعات المبيعات</a></li>

              <!-- المرحلة 2: تحليلات أعمق -->
              <li class="list-group-item text-muted mt-2"><i class="fa-solid fa-chart-pie"></i> — المرحلة 2: تحليلات —</li>
              <li class="list-group-item"><i class="fa-solid fa-table-cells"></i><a href="reports/variant_matrix.php">مصفوفة المقاسات/الألوان</a></li>
              <li class="list-group-item"><i class="fa-regular fa-snowflake"></i><a href="reports/slow_moving.php">البضاعة الراكدة (بطيئة الحركة)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-truck-field"></i><a href="reports/suppliers_performance.php">أداء الموردين (زمن التوريد/الملء/المرتجعات)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-percent"></i><a href="reports/discounts_tax_analysis.php">تحليل الخصومات والضرائب</a></li>
              <li class="list-group-item"><i class="fa-solid fa-tag"></i><a href="reports/stock_valuation_retail.php">تقييم المخزون بسعر البيع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-receipt"></i><a href="reports/z_report.php">Z-Report (ملخص يومي/شِفت)</a></li>
              <li class="list-group-item"><i class="fa-solid fa-chart-line"></i><a href="reports/branch_performance.php">تحليل أداء الفروع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-wave-square"></i><a href="reports/moving_average_cost.php">التكلفة المتوسطة المتحركة</a></li>

              <!-- المرحلة 3: بعد تفعيل المبيعات الكاملة -->
              <li class="list-group-item text-muted mt-2"><i class="fa-solid fa-cash-register"></i> — المرحلة 3: تقارير المبيعات —</li>
              <li class="list-group-item"><i class="fa-solid fa-chart-line"></i><a href="reports/sales_summary.php">ملخص المبيعات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-money-check-dollar"></i><a href="reports/payments_breakdown.php">تحليل طرق الدفع</a></li>
              <li class="list-group-item"><i class="fa-solid fa-ranking-star"></i><a href="reports/top_products.php">أعلى المنتجات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-layer-group"></i><a href="reports/category_performance.php">أداء الفئات</a></li>
              <li class="list-group-item"><i class="fa-solid fa-fire-flame-curved"></i><a href="reports/hourly_heatmap.php">ساعات الذروة</a></li>
              <li class="list-group-item"><i class="fa-solid fa-user-tie"></i><a href="reports/customers_ranking.php">ترتيب العملاء</a></li>
              <li class="list-group-item"><i class="fa-solid fa-rotate-left"></i><a href="reports/returns_analysis.php">مرتجعات المبيعات</a></li>

            </ul>
          </div>
        </div>
      </div>

    </div>
  </aside>

  <!-- Main (شمال) -->
  <main>
    <div class="page-head">
      <h2>مرحباً بك في لوحة التحكم</h2>
    </div>

    <div class="cards">

      <!-- كارت بيانات المتجر -->
      <div class="card-tile">
        <?php if ($store && !empty($logo)): ?>
          <img class="tile-logo" src="uploads/<?= htmlspecialchars($logo) ?>" alt="شعار المتجر">
        <?php else: ?>
          <div class="tile-icon"><i class="fa-solid fa-store"></i></div>
        <?php endif; ?>
        <div class="tile-title"><?= htmlspecialchars($nameAr) ?></div>
        <div class="tile-desc">
          <?= htmlspecialchars($nameEn) ?>
          <?php if (!empty($phone)): ?><br>📞 <?= htmlspecialchars($phone) ?><?php endif; ?>
          <?php if (!empty($website)): ?><br>🌐 <a href="<?= htmlspecialchars($website) ?>" target="_blank"><?= htmlspecialchars($website) ?></a><?php endif; ?>
        </div>
        <a class="tile-action" href="storeInfo.php">إدارة</a>
      </div>

      <!-- كروت موحّدة -->
      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-folder-tree"></i></div>
        <div class="tile-title">إدارة الأقسام والفئات</div>
        <div class="tile-desc">أضف وعدّل الفئات والتنظيمات</div>
        <a class="tile-action" href="categories.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-shirt"></i></div>
        <div class="tile-title">إدارة المنتجات</div>
        <div class="tile-desc">إضافة وتعديل وحذف المنتجات</div>
        <a class="tile-action" href="products.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-ruler-combined"></i></div>
        <div class="tile-title">المقاسات والألوان</div>
        <div class="tile-desc">تعريف المقاسات والألوان والمتغيّرات</div>
        <a class="tile-action" href="variants.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-boxes-stacked"></i></div>
        <div class="tile-title">المخزون</div>
        <div class="tile-desc">متابعة وإدارة كميات الفروع</div>
        <a class="tile-action" href="inventory.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-cash-register"></i></div>
        <div class="tile-title">نقطة البيع</div>
        <div class="tile-desc">بيع مباشر وإصدار الفواتير</div>
        <a class="tile-action" href="pos/sale.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-users-gear"></i></div>
        <div class="tile-title">المستخدمون والصلاحيات</div>
        <div class="tile-desc">إدارة الحسابات والمجموعات</div>
        <a class="tile-action" href="users.php">إدارة</a>
      </div>

      <div class="card-tile">
        <div class="tile-icon"><i class="fa-solid fa-sliders"></i></div>
        <div class="tile-title">الإعدادات</div>
        <div class="tile-desc">تخصيص إعدادات النظام</div>
        <a class="tile-action" href="settings.php">إدارة</a>
      </div>

    </div>
  </main>

</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // وضع ليلي (محفوظ في LocalStorage)
  const body = document.body;
  const darkSwitch = document.getElementById("darkSwitch");
  if(localStorage.getItem("darkMode") === "true"){
    body.classList.add("dark");
    darkSwitch.textContent = "☀️";
  }
  darkSwitch.addEventListener("click", () => {
    body.classList.toggle("dark");
    const isDark = body.classList.contains("dark");
    localStorage.setItem("darkMode", isDark);
    darkSwitch.textContent = isDark ? "☀️" : "🌙";
  });
</script>

</body>
</html>
