<?php
require_once __DIR__ . '/../core/auth.php';

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (login($username, $password)) {
        // ✅ تسجيل الدخول ناجح → تحويل للداشبورد
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "❌ اسم المستخدم أو كلمة المرور غير صحيحة";
    }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>تسجيل الدخول</title>
  <style>
    body {
      font-family: Tahoma, Arial, sans-serif;
      background: url('../images/lg_main.jpg') no-repeat center center fixed;
      background-size: cover;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .login-box {
      background: rgba(255, 255, 255, 0.9); /* خلفية بيضاء بشفافية */
      padding: 30px;
      border-radius: 10px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.2);
      width: 320px;
      text-align: center;
    }
    .login-box h3 {
      margin-bottom: 20px;
      color: #333;
    }
    .login-box input {
      width: 100%;
      padding: 10px;
      margin: 8px 0;
      border: 1px solid #ccc;
      border-radius: 6px;
      font-size: 14px;
    }
    .login-box button {
      width: 100%;
      padding: 10px;
      background: #3498db;
      border: none;
      border-radius: 6px;
      color: #fff;
      font-size: 15px;
      cursor: pointer;
      transition: background 0.3s;
    }
    .login-box button:hover {
      background: #2980b9;
    }
    .error {
      background: #f8d7da;
      color: #721c24;
      padding: 8px;
      margin-bottom: 12px;
      border-radius: 6px;
      font-size: 14px;
    }
  </style>
</head>
<body>
  <div class="login-box">
    <h3>دخول الإدارة</h3>
    <?php if($error): ?><div class="error"><?= $error ?></div><?php endif; ?>
    <form method="post">
      <input name="username" placeholder="اسم المستخدم" required>
      <input name="password" type="password" placeholder="كلمة السر" required>
      <button type="submit">دخول</button>
    </form>
  </div>
</body>
</html>
