<?php
require_once __DIR__ . '/_init.php';
$title='أعمار الذمم الدائنة'; include __DIR__ . '/_layout_top.php';

$date_base = param('date_base','invoice_date'); // invoice_date أو order_date
$today = date('Y-m-d');

$sql="SELECT s.name AS supplier, p.id, p.total, p.paid,
      DATEDIFF(?, IFNULL(p.invoice_date, p.order_date)) AS age_days
      FROM purchases p
      JOIN suppliers s ON s.id=p.supplier_id
      WHERE p.deleted_at IS NULL";
$st=$pdo->prepare($sql); $st->execute([$today]); $all=$st->fetchAll(PDO::FETCH_ASSOC);

$bucket = ['0-30'=>0,'31-60'=>0,'61-90'=>0,'>90'=>0]; $map=[];
foreach($all as $r){
  $due = max(0, (float)$r['total']-(float)$r['paid']);
  if ($due<=0) continue;
  $age = (int)$r['age_days'];
  $b = $age<=30?'0-30':($age<=60?'31-60':($age<=90?'61-90':'>90'));
  $bucket[$b] += $due;
  $map[$r['supplier']][$b] = ($map[$r['supplier']][$b] ?? 0) + $due;
}
?>
<div class="panel p-3">
  <div class="d-flex justify-content-between align-items-center">
    <div><span class="badge bg-info">تاريخ الأساس: اليوم <?= htmlspecialchars($today) ?></span></div>
    <div class="d-flex gap-2">
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </div>
  <hr>
  <div class="row g-3">
    <?php foreach($bucket as $k=>$v): ?>
      <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted"><?= $k ?></div><div class="fs-5 fw-bold"><?= money($v) ?></div></div></div>
    <?php endforeach; ?>
  </div>
  <hr>
  <div class="table-responsive">
    <table class="table table-hover text-center">
      <thead class="table-light"><tr><th>المورد</th><th>0-30</th><th>31-60</th><th>61-90</th><th>>90</th><th>الإجمالي المستحق</th></tr></thead>
      <tbody>
        <?php if(!$map): ?><tr><td colspan="6" class="text-muted">لا يوجد مستحقات.</td></tr>
        <?php else: foreach($map as $sup=>$arr): $tot = array_sum($arr); ?>
          <tr>
            <td class="text-start"><?= htmlspecialchars($sup) ?></td>
            <td><?= money($arr['0-30']??0) ?></td><td><?= money($arr['31-60']??0) ?></td><td><?= money($arr['61-90']??0) ?></td><td><?= money($arr['>90']??0) ?></td>
            <td class="fw-bold"><?= money($tot) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
