<?php
require_once __DIR__ . '/_init.php';
$title = 'تحليل الخصومات والضرائب (مشتريات)'; include __DIR__.'/_layout_top.php';

$date_from = param('date_from',''); $date_to = param('date_to','');
$branch_id = param('branch_id',''); $supplier_id = param('supplier_id','');
$brs=branches($pdo); $sups=suppliers($pdo);

$where=["p.deleted_at IS NULL"]; $p=[];
if($date_from!==''){ $where[]="p.order_date>=:df"; $p[':df']=$date_from; }
if($date_to!==''){ $where[]="p.order_date<=:dt"; $p[':dt']=$date_to; }
if($branch_id!==''){ $where[]="p.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
if($supplier_id!==''){ $where[]="p.supplier_id=:sid"; $p[':sid']=(int)$supplier_id; }
$whereSQL='WHERE '.implode(' AND ',$where);

// نحسب خصم الرأس كقيمة فعلية + الضريبة العامة
$sql="
SELECT
  COUNT(*) AS cnt,
  SUM(p.subtotal) AS sum_subtotal,
  SUM(CASE WHEN p.discount_type='percent' THEN (p.subtotal * (p.discount_value/100)) ELSE p.discount_value END) AS sum_header_disc,
  SUM((p.subtotal - (CASE WHEN p.discount_type='percent' THEN (p.subtotal * (p.discount_value/100)) ELSE p.discount_value END)) * (p.tax_rate/100)) AS sum_header_tax,
  SUM(p.shipping + p.other_fees) AS sum_extra,
  SUM(p.total) AS sum_total
FROM purchases p
$whereSQL
";
$st=$pdo->prepare($sql); $st->execute($p); $agg=$st->fetch(PDO::FETCH_ASSOC) ?: [];

$cnt = (int)($agg['cnt'] ?? 0);
$sum_sub = (float)($agg['sum_subtotal'] ?? 0);
$sum_disc = (float)($agg['sum_header_disc'] ?? 0);
$sum_tax  = (float)($agg['sum_header_tax'] ?? 0);
$sum_extra= (float)($agg['sum_extra'] ?? 0);
$sum_total= (float)($agg['sum_total'] ?? 0);

$eff_disc_pct = $sum_sub>0 ? round(($sum_disc/$sum_sub)*100,2) : 0;
$base_after_disc = max(0, $sum_sub - $sum_disc);
$eff_tax_pct = $base_after_disc>0 ? round(($sum_tax/$base_after_disc)*100,2) : 0;
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">الكل</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select></div>
    <div class="col-md-3"><label class="form-label">المورد</label>
      <select class="form-select" name="supplier_id"><option value="">الكل</option>
        <?php foreach($sups as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $supplier_id!==''&&(int)$supplier_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select></div>
    <div class="col-12 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>
  <div class="row g-3">
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">عدد الفواتير</div><div class="fs-5 fw-bold"><?= $cnt ?></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">إجمالي قبل الخصم</div><div class="fs-5 fw-bold"><?= money($sum_sub) ?></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">خصومات رأس</div><div class="fs-5 fw-bold"><?= money($sum_disc) ?> <small class="text-muted">(<?= $eff_disc_pct ?>%)</small></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">ضريبة عامة</div><div class="fs-5 fw-bold"><?= money($sum_tax) ?> <small class="text-muted">(<?= $eff_tax_pct ?>%)</small></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">شحن ورسوم</div><div class="fs-5 fw-bold"><?= money($sum_extra) ?></div></div></div>
    <div class="col-md-3"><div class="panel p-3 text-center"><div class="text-muted">الإجمالي النهائي</div><div class="fs-5 fw-bold"><?= money($sum_total) ?></div></div></div>
  </div>
  <div class="alert alert-info mt-3">
    * التحليل هنا يعتمد على خصم رأس الفاتورة (<code>discount_type / discount_value</code>) والضريبة العامة (<code>tax_rate</code>)—خصومات/ضرائب أسطر البنود محسوبة داخل <code>subtotal</code>.
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
