<?php
require_once __DIR__.'/_init.php';
$title='خريطة ساعات الذروة';
include __DIR__.'/_layout_top.php';

$df=param('date_from', date('Y-m-01')); $dt=param('date_to', date('Y-m-d')); $branch_id=param('branch_id','');
$brs=branches($pdo);

$hasSales=hasTable($pdo,'sales'); $dateCol=null;
if($hasSales){ foreach(['created_at','invoice_date','sale_date'] as $c){ if(hasColumn($pdo,'sales',$c)){ $dateCol=$c; break; } } }

$hours = range(0,23);
$days = []; // تاريخ => [ساعة => إجمالي]
$dayLabels=[];

if ($hasSales && $dateCol){
  $w=["s.deleted_at IS NULL"]; $p=[];
  $w[]="DATE(s.`$dateCol`) BETWEEN :df AND :dt"; $p[':df']=$df; $p[':dt']=$dt;
  if($branch_id!==''){ $w[]="s.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
  $wsql='WHERE '.implode(' AND ',$w);
  $sql="SELECT DATE(s.`$dateCol`) AS d, HOUR(s.`$dateCol`) AS h, SUM(s.total) AS tot
        FROM sales s $wsql GROUP BY d,h ORDER BY d,h";
  $st=$pdo->prepare($sql); $st->execute($p);
  foreach($st->fetchAll(PDO::FETCH_ASSOC) as $r){
    $d=$r['d']; $h=(int)$r['h']; $v=(float)$r['tot'];
    $days[$d][$h]=($days[$d][$h]??0)+$v; $dayLabels[$d]=true;
  }
}

ksort($days); $dayLabels=array_keys($dayLabels);

if (isset($_GET['export']) && $_GET['export']==='csv'){
  $out=[]; foreach($days as $d=>$row){ foreach($hours as $h){ $out[]=['date'=>$d,'hour'=>$h,'total'=>$row[$h]??0]; } }
  csv_export('hourly_heatmap.csv',['date','hour','total'],$out);
}
?>
<div class="panel p-3">
  <?php if(!$hasSales || !$dateCol): ?><div class="alert alert-warning">يستلزم التقرير جدول <code>sales</code> بعمود تاريخ/وقت.</div><?php endif; ?>
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2"><button class="btn btn-brand">تطبيق</button><a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a><button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button></div>
  </form>
  <hr>

  <?php if($days): ?>
  <div class="table-responsive">
    <table class="table table-bordered text-center align-middle">
      <thead class="table-light"><tr><th>اليوم \ الساعة</th><?php foreach($hours as $h): ?><th><?= $h ?></th><?php endforeach; ?><th>الإجمالي</th></tr></thead>
      <tbody>
        <?php foreach($days as $d=>$row): $rowTotal=array_sum($row); ?>
          <tr>
            <th class="table-light"><?= htmlspecialchars($d) ?></th>
            <?php foreach($hours as $h): $v=(float)($row[$h]??0); ?>
              <td class="<?= $v==0?'text-muted':'' ?>"><?= $v? money($v):'0' ?></td>
            <?php endforeach; ?>
            <th class="table-light"><?= money($rowTotal) ?></th>
          </tr>
        <?php endforeach; ?>
      </tbody>
      <tfoot class="table-secondary">
        <tr>
          <th>الإجمالي</th>
          <?php $colTot=[]; foreach($hours as $h){ $s=0; foreach($days as $r){ $s+=(float)($r[$h]??0);} $colTot[$h]=$s; echo '<th>'.money($s).'</th>'; } ?>
          <th><?= money(array_sum($colTot)) ?></th>
        </tr>
      </tfoot>
    </table>
  </div>
  <?php else: ?>
    <div class="text-muted">لا بيانات ضمن الفترة.</div>
  <?php endif; ?>
</div>
<?php include __DIR__.'/_layout_bottom.php';
