<?php
require_once __DIR__.'/_init.php';
$title='تحليل مرتجعات المبيعات';
include __DIR__.'/_layout_top.php';

$df=param('date_from',''); $dt=param('date_to',''); $branch_id=param('branch_id','');
$brs=branches($pdo);

$hasRet=hasTable($pdo,'sales_returns');
if(!$hasRet){ echo '<div class="panel p-3 alert alert-warning">لا يوجد جدول <code>sales_returns</code> حتى الآن.</div>'; include __DIR__.'/_layout_bottom.php'; exit; }

$dateCol=null; foreach(['created_at','return_date'] as $c){ if(hasColumn($pdo,'sales_returns',$c)){ $dateCol=$c; break; } }

$w=["r.deleted_at IS NULL"]; $p=[];
if($dateCol){
  if($df!==''){ $w[]="DATE(r.`$dateCol`) >= :df"; $p[':df']=$df; }
  if($dt!==''){ $w[]="DATE(r.`$dateCol`) <= :dt"; $p[':dt']=$dt; }
}
if($branch_id!==''){ $w[]="r.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
$wsql='WHERE '.implode(' AND ',$w);

$st=$pdo->prepare("SELECT r.id, r.total, r.`$dateCol` AS d, b.BranchName
                   FROM sales_returns r
                   LEFT JOIN Branches b ON b.BranchID=r.branch_id
                   $wsql
                   ORDER BY r.id DESC LIMIT 2000");
$st->execute($p); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

$sum=0; foreach($rows as $r){ $sum+=(float)$r['total']; }
if (isset($_GET['export']) && $_GET['export']==='csv'){ csv_export('sales_returns.csv',['id','date','branch','total'], array_map(fn($r)=>['id'=>$r['id'],'date'=>$r['d'],'branch'=>$r['BranchName'],'total'=>$r['total']], $rows)); }
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2"><button class="btn btn-brand">تطبيق</button><a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a><button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button></div>
  </form>
  <hr>
  <div class="alert alert-info">إجمالي مرتجعات الفترة: <b><?= money($sum) ?></b></div>
  <div class="table-responsive">
    <table class="table table-striped text-center align-middle">
      <thead class="table-light"><tr><th>#</th><th>التاريخ</th><th>الفرع</th><th>القيمة</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="4" class="text-muted">لا بيانات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr><td><?= (int)$r['id'] ?></td><td><?= htmlspecialchars($r['d']) ?></td><td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td><td class="fw-bold"><?= money($r['total']) ?></td></tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
