<?php
require_once __DIR__ . '/_init.php';
$title='مرتجعات المبيعات'; include __DIR__.'/_layout_top.php';

if (!hasTable($pdo,'sales_returns')){
  echo '<div class="panel p-3 alert alert-info">لم يتم تفعيل جدول مرتجعات المبيعات بعد.</div>';
  include __DIR__.'/_layout_bottom.php'; exit;
}

$date_from=param('date_from',''); $date_to=param('date_to',''); $branch_id=param('branch_id','');
$brs=branches($pdo);

$where=["r.deleted_at IS NULL"]; $params=[];
if($date_from!==''){ $where[]="r.return_date>=:df"; $params[':df']=$date_from; }
if($date_to!==''){ $where[]="r.return_date<=:dt"; $params[':dt']=$date_to; }
if($branch_id!==''){ $where[]="r.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
$whereSQL='WHERE '.implode(' AND ',$where);

$sql="SELECT r.id, r.return_date, b.BranchName, r.total, r.status
      FROM sales_returns r
      LEFT JOIN Branches b ON b.BranchID=r.branch_id
      $whereSQL
      ORDER BY r.id DESC";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-4"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-4"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-md-4"><label class="form-label">الفرع</label><select class="form-select" name="branch_id"><option value="">الكل</option>
      <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
    </select></div>
    <div class="col-12 d-flex gap-2"><button class="btn btn-brand">تطبيق</button><button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button></div>
  </form><hr>
  <div class="table-responsive">
    <table class="table table-hover text-center">
      <thead class="table-light"><tr><th>#</th><th>التاريخ</th><th>الفرع</th><th>الحالة</th><th>الإجمالي</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="5" class="text-muted">لا توجد بيانات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= htmlspecialchars($r['return_date']) ?></td>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td><?= htmlspecialchars($r['status'] ?? '-') ?></td>
            <td class="fw-bold"><?= money($r['total']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
