<?php
require_once __DIR__ . '/_init.php';
$title='البضاعة الراكدة (بطيئة الحركة)';
include __DIR__.'/_layout_top.php';

$days = (int)(param('days','60') ?: 60);
$branch_id = param('branch_id','');
$brs = branches($pdo);

$hasCreated = hasColumn($pdo,'inventory_movements','created_at');

$params=[]; $where=[];
if ($branch_id!==''){ $where[]="s.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
$whereSQL = $where? 'WHERE '.implode(' AND ',$where) : '';

/* نجلب المخزون + آخر حركة (إن وُجد created_at) */
if ($hasCreated){
  $sql="SELECT v.id AS variant_id, p.name_ar AS product_name, v.sku, b.BranchName, s.branch_id, s.quantity,
        (SELECT MAX(m.created_at) FROM inventory_movements m WHERE m.variant_id=v.id AND (s.branch_id IS NULL OR m.branch_id=s.branch_id)) AS last_move
        FROM product_variant_stock s
        JOIN product_variants v ON v.id=s.variant_id
        JOIN products p ON p.id=v.product_id
        LEFT JOIN Branches b ON b.BranchID=s.branch_id
        $whereSQL
        ORDER BY last_move IS NULL DESC, last_move ASC, p.name_ar
        LIMIT 2000";
} else {
  $sql="SELECT v.id AS variant_id, p.name_ar AS product_name, v.sku, b.BranchName, s.branch_id, s.quantity,
        NULL AS last_move
        FROM product_variant_stock s
        JOIN product_variants v ON v.id=s.variant_id
        JOIN products p ON p.id=v.product_id
        LEFT JOIN Branches b ON b.BranchID=s.branch_id
        $whereSQL
        ORDER BY p.name_ar
        LIMIT 2000";
}
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

$cutoff = new DateTime('-'.$days.' days');
$filtered=[];
foreach($rows as $r){
  // نعرض فقط اللي كميته > 0
  if ((int)$r['quantity']<=0) continue;
  if ($hasCreated){
    if ($r['last_move']===null || new DateTime($r['last_move']) <= $cutoff){
      $filtered[]=$r;
    }
  } else {
    // بدون created_at: نعرض الجميع كراكد "تقريبي"
    $filtered[]=$r;
  }
}

if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('slow_moving.csv',['product_name','sku','BranchName','quantity','last_move'],$filtered);
}
?>
<div class="panel p-3">
  <?php if(!$hasCreated): ?>
    <div class="alert alert-warning">لا يوجد عمود <code>created_at</code> في <code>inventory_movements</code>؛ سيتم اعتبار الراكد تقديريًا بناءً على المخزون فقط.</div>
  <?php endif; ?>
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">عدد الأيام دون حركة ≥</label><input type="number" min="1" class="form-control" name="days" value="<?= (int)$days ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-6 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form><hr>
  <div class="table-responsive">
    <table class="table table-hover text-center">
      <thead class="table-light"><tr><th>الصنف</th><th>SKU</th><th>الفرع</th><th>الكمية</th><th>آخر حركة</th></tr></thead>
      <tbody>
        <?php if(!$filtered): ?><tr><td colspan="5" class="text-muted">لا توجد أصناف راكدة حسب المعايير.</td></tr>
        <?php else: foreach($filtered as $r): ?>
          <tr>
            <td class="text-start"><?= htmlspecialchars($r['product_name']) ?></td>
            <td><?= htmlspecialchars($r['sku']) ?></td>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td class="fw-bold"><?= (int)$r['quantity'] ?></td>
            <td><?= htmlspecialchars($r['last_move'] ?? '—') ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
