<?php
require_once __DIR__ . '/../core/auth.php';
require_login();

$pdo = db();
$success = $error = null;

// اقرأ أول سجل (لو موجود) لاستخدامه في العرض والتعديل من جدول storeinfo
$existingStmt = $pdo->query("SELECT * FROM storeinfo ORDER BY id ASC LIMIT 1");
$store = $existingStmt->fetch();

// عند الحفظ
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // 1) قراءة المدخلات
    $CompanyName  = trim($_POST['CompanyName']  ?? '');
    $CompanyEName = trim($_POST['CompanyEName'] ?? '');
    $Phone        = trim($_POST['Phone']        ?? '');
    $Website      = trim($_POST['Website']      ?? '');
    $logoName     = null;

    // تبسيط/تصحيح الموقع (اختياري)
    if ($Website === '') {
        $Website = null;
    } else {
        if (!preg_match('~^https?://~i', $Website)) {
            $Website = 'https://' . $Website;
        }
    }

    // 2) معالجة ملف الشعار (لو تم رفعه)
    try {
        if (isset($_FILES['Logo']) && $_FILES['Logo']['error'] === UPLOAD_ERR_OK) {
            $allowedExt  = ['jpg','jpeg','png','webp'];
            $maxSize     = 3 * 1024 * 1024; // 3MB
            $uploadDirFs = __DIR__ . '/uploads/'; // مسار فعلي
            $uploadDirUi = 'uploads/';            // مسار للعرض داخل الموقع

            if (!is_dir($uploadDirFs)) {
                mkdir($uploadDirFs, 0777, true);
            }

            $tmpName = $_FILES['Logo']['tmp_name'];
            $size    = (int)$_FILES['Logo']['size'];
            $ext     = strtolower(pathinfo($_FILES['Logo']['name'], PATHINFO_EXTENSION));

            if (!in_array($ext, $allowedExt, true)) {
                throw new RuntimeException('صيغة الصورة غير مسموح بها. المسموح: jpg, jpeg, png, webp');
            }
            if ($size > $maxSize) {
                throw new RuntimeException('حجم الصورة كبير (الحد الأقصى 3MB).');
            }

            $logoName = time() . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
            $dest     = $uploadDirFs . $logoName;
            if (!move_uploaded_file($tmpName, $dest)) {
                throw new RuntimeException('فشل رفع الصورة، حاول مرة أخرى.');
            }

            // لو تحديث وكان فيه لوجو قديم، احذفه (اختياري)
            if ($store && !empty($store['Logo'])) {
                $old = $uploadDirFs . $store['Logo'];
                if (is_file($old)) { @unlink($old); }
            }
        }
    } catch (Throwable $ex) {
        $error = "❌ خطأ في رفع الشعار: " . htmlspecialchars($ex->getMessage(), ENT_QUOTES, 'UTF-8');
    }

    // 3) إدخال/تحديث
    if (!$error) {
        try {
            if ($store) {
                // تحديث أول سجل
                $sql = "UPDATE storeinfo
                        SET CompanyName = :CompanyName,
                            CompanyEName = :CompanyEName,
                            Phone = :Phone,
                            Website = :Website"
                        . ($logoName ? ", Logo = :Logo" : "") .
                       " WHERE id = :id";
                $stmt = $pdo->prepare($sql);
                $params = [
                    ':CompanyName'  => $CompanyName,
                    ':CompanyEName' => $CompanyEName,
                    ':Phone'        => $Phone,
                    ':Website'      => $Website,
                    ':id'           => $store['id']
                ];
                if ($logoName) { $params[':Logo'] = $logoName; }
                $stmt->execute($params);
            } else {
                // إدراج أول سجل
                $sql = "INSERT INTO storeinfo (CompanyName, CompanyEName, Phone, Website, Logo)
                        VALUES (:CompanyName, :CompanyEName, :Phone, :Website, :Logo)";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':CompanyName'  => $CompanyName,
                    ':CompanyEName' => $CompanyEName,
                    ':Phone'        => $Phone,
                    ':Website'      => $Website,
                    ':Logo'         => $logoName
                ]);
            }

            $success = "✅ تم الحفظ بنجاح!";
            // إعادة قراءة السجل بعد الحفظ لعرضه محدثًا
            $store = $pdo->query("SELECT * FROM storeinfo ORDER BY id ASC LIMIT 1")->fetch();
        } catch (PDOException $e) {
            $error = "❌ خطأ: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
        }
    }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>تعديل بيانات المتجر</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
  <style>
    body {
      font-family: "Tajawal", Tahoma, Arial, sans-serif;
      background: #f5f7fa;
      margin: 0;
      padding: 0;
    }
    header {
      background: linear-gradient(135deg,#0f2027,#203a43,#2c5364);
      color: #fff;
      padding: 15px 30px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3);
      position: relative;
    }
    header h1 { margin: 0; font-size: 24px; font-weight: bold; text-align: center; flex: 1; }
    .user-info {
      display: flex; align-items: center; gap: 12px;
      background: rgba(255,255,255,0.1); padding: 6px 14px; border-radius: 50px;
      transition: all 0.3s ease-in-out;
    }
    .user-info:hover { background: rgba(255,255,255,0.2); }
    .user-info img {
      width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid #1abc9c;
    }
    .user-info span { font-weight: bold; font-size: 14px; }
    .user-info a {
      background: #e74c3c; border: none; color: #fff; padding: 5px 12px; border-radius: 30px; font-size: 13px; text-decoration: none;
      transition: background 0.3s;
    }
    .user-info a:hover { background: #c0392b; }
    #darkSwitch {
      background: #1abc9c; color: #fff; border: none; border-radius: 30px; padding: 8px 16px; cursor: pointer; font-weight: bold; transition: all 0.3s;
    }
    #darkSwitch:hover { background: #16a085; }
    body.dark { background:#121212; color:#eee; }
    body.dark header { background: linear-gradient(135deg,#000,#333); border-bottom: 3px solid #1abc9c; }
    body.dark .user-info { background: rgba(255,255,255,0.1); }
    .container { display: flex; min-height: calc(100vh - 60px); }
    .card{ border:none;border-radius:18px;box-shadow:0 8px 20px rgba(0,0,0,.12);overflow:hidden }
    .card-header{ background: linear-gradient(135deg,#2980b9,#2c3e50); color:#fff; font-weight:800 }
    .form-control, .form-select{ border-radius:10px }
    .btn-primary{ background:#c33764;border:none }
    .btn-primary:hover{ background:#1d2671 }
    .logo-preview{ width:90px;height:90px;border-radius:50%;object-fit:cover;border:2px solid #ddd }
  </style>
</head>
<body>

<header>
  <!-- بيانات المستخدم يمين -->
  <div class="user-info">
    <img src="uploads/<?= htmlspecialchars($_SESSION['avatar'] ?? 'default.png') ?>"
         alt="Avatar" class="rounded-circle border border-2 border-light"
         style="width:40px;height:40px;object-fit:cover;">
    <span><?= htmlspecialchars($_SESSION['admin_username']) ?></span>
    <a href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> خروج</a>
  </div>

  <!-- وسط: عنوان الصفحة -->
  <h1 class="page-title"><i class="fa-solid fa-store"></i> تعديل بيانات المتجر</h1>

  <!-- زر الوضع الليلي شمال -->
  <button id="darkSwitch">🌙</button>
</header>

<div class="container my-4">
  <div class="row justify-content-center">
    <div class="col-lg-7 col-md-9">
      <div class="card">
        <div class="card-header text-center py-3">
          📋 <?= $store ? 'تعديل بيانات المتجر' : 'تسجيل متجر جديد' ?>
        </div>
        <div class="card-body">

          <?php if ($success): ?>
            <div class="alert alert-success text-center"><?= $success ?></div>
          <?php elseif ($error): ?>
            <div class="alert alert-danger text-center"><?= $error ?></div>
          <?php endif; ?>

          <!-- معاينة الشعار الحالي (إن وجد) -->
          <?php if ($store && !empty($store['Logo'])): ?>
            <div class="text-center mb-3">
              <img class="logo-preview" src="uploads/<?= htmlspecialchars($store['Logo'], ENT_QUOTES, 'UTF-8') ?>" alt="Logo">
            </div>
          <?php endif; ?>

          <form method="POST" enctype="multipart/form-data" class="row g-3">
            <div class="col-12">
              <label class="form-label">اسم الشركة:</label>
              <input type="text" name="CompanyName" class="form-control" required
                     value="<?= htmlspecialchars($store['CompanyName'] ?? '', ENT_QUOTES, 'UTF-8') ?>">
            </div>

            <div class="col-12">
              <label class="form-label">Company English Name:</label>
              <input type="text" name="CompanyEName" class="form-control" required
                     value="<?= htmlspecialchars($store['CompanyEName'] ?? '', ENT_QUOTES, 'UTF-8') ?>">
            </div>

            <div class="col-md-6">
              <label class="form-label">رقم الهاتف:</label>
              <input type="text" name="Phone" class="form-control"
                     value="<?= htmlspecialchars($store['Phone'] ?? '', ENT_QUOTES, 'UTF-8') ?>">
            </div>

            <div class="col-md-6">
              <label class="form-label">الموقع الإلكتروني (اختياري):</label>
              <input type="text" name="Website" class="form-control" placeholder="مثال: google.com أو www.google.com"
                     value="<?= htmlspecialchars($store['Website'] ?? '', ENT_QUOTES, 'UTF-8') ?>">
              <div class="form-text">يمكنك تركه فارغًا</div>
            </div>

            <div class="col-12">
              <label class="form-label">الشعار (Logo):</label>
              <input type="file" name="Logo" class="form-control" accept=".jpg,.jpeg,.png,.webp,image/*">
              <div class="form-text">الحد الأقصى 3MB — الصيغ المسموح بها: JPG, PNG, WEBP</div>
            </div>

            <div class="col-12 text-center mt-2">
              <button type="submit" class="btn btn-primary px-5">
                <i class="fa-solid fa-floppy-disk"></i> حفظ
              </button>
              <a href="dashboard.php" class="btn btn-outline-secondary ms-2">الرجوع للوحة التحكم</a>
            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</div>

<script>
  // Dark Mode Toggle
  const body = document.body;
  const darkSwitch = document.getElementById("darkSwitch");
  if (localStorage.getItem("darkMode") === "true") {
    body.classList.add("dark");
    darkSwitch.textContent = "☀️";
  }
  darkSwitch.addEventListener("click", () => {
    body.classList.toggle("dark");
    const isDark = body.classList.contains("dark");
    localStorage.setItem("darkMode", isDark);
    darkSwitch.textContent = isDark ? "☀️" : "🌙";
  });
</script>

</body>
</html>
