<?php
require_once __DIR__ . '/../core/auth.php';
require_login();

$pdo = db();

// جلب المجموعات
$groups = $pdo->query("SELECT id, name FROM groups ORDER BY id")->fetchAll(PDO::FETCH_KEY_PAIR);

// جلب المستخدمين
$users = $pdo->query("SELECT a.*, g.name as group_name
                      FROM admins a 
                      LEFT JOIN groups g ON a.group_id = g.id
                      ORDER BY a.id DESC")->fetchAll();

// الإحصائيات
$totalGroups = $pdo->query("SELECT COUNT(*) FROM groups")->fetchColumn();
$totalPermissions = $pdo->query("SELECT COUNT(*) FROM permissions")->fetchColumn();
$totalUsers = $pdo->query("SELECT COUNT(*) FROM admins")->fetchColumn();

?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة المستخدمين</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<header class="mb-4">
  <div class="d-flex justify-content-between align-items-center p-3 bg-dark text-white shadow-sm">
    <!-- يمين: بيانات المستخدم -->
    <div class="d-flex align-items-center gap-2">
        <img src="uploads/<?= htmlspecialchars($_SESSION['avatar'] ?? 'default.png') ?>" 
            alt="Avatar" 
            class="rounded-circle border border-2 border-light"
            style="width:40px;height:40px;object-fit:cover;">
            
        <span class="fw-bold"><?= htmlspecialchars($_SESSION['admin_username'] ?? 'Admin') ?></span>
        
        <a href="logout.php" class="btn btn-sm btn-outline-light">خروج</a>
    </div>


    <!-- وسط: عنوان الصفحة -->
    <h1 class="h5 m-0">👥 إدارة المستخدمين</h1>

    <!-- شمال: زر الوضع الليلي -->
    <button id="darkSwitch" class="btn btn-sm btn-success">🌙</button>
  </div>
</header>
<div class="container py-4">
<div class="text-end mb-3">
  <a href="dashboard.php" class="btn btn-secondary">
    <i class="fa-solid fa-house"></i> الرئيسية
  </a>
</div>
    <!-- كروت الإحصائيات -->
<div class="row text-center mb-4">
  <div class="col-md-4 mb-3">
    <div class="card text-white shadow" style="background:linear-gradient(135deg,#3498db,#2c3e50);">
      <div class="card-body">
        <h5><i class="fa-solid fa-users-gear"></i> عدد المجموعات</h5>
        <h2><?= $totalGroups ?></h2>
      </div>
    </div>
  </div>

  <div class="col-md-4 mb-3">
    <div class="card text-white shadow" style="background:linear-gradient(135deg,#1abc9c,#145a32);">
      <div class="card-body">
        <h5><i class="fa-solid fa-key"></i> عدد الصلاحيات</h5>
        <h2><?= $totalPermissions ?></h2>
      </div>
    </div>
  </div>

  <div class="col-md-4 mb-3">
    <div class="card text-white shadow" style="background:linear-gradient(135deg,#e67e22,#d35400);">
      <div class="card-body">
        <h5><i class="fa-solid fa-user"></i> عدد المستخدمين</h5>
        <h2><?= $totalUsers ?></h2>
      </div>
    </div>
  </div>
</div>

  <div class="d-flex justify-content-between mb-3">
    <h2>👥 إدارة المستخدمين</h2>
    <a href="user_form.php" class="btn btn-primary">➕ إضافة مستخدم</a>
  </div>

  <table class="table table-striped table-bordered text-center align-middle">
    <thead class="table-dark">
      <tr>
        <th>#</th>
        <th>الأفاتار</th>
        <th>اسم الدخول</th>
        <th>الاسم</th>
        <th>الهاتف</th>
        <th>البريد</th>
        <th>المجموعة</th>
        <th>الحالة</th>
        <th>إجراءات</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($users as $u): ?>
      <tr>
        <td><?= $u['id'] ?></td>
        <td>
          <?php if ($u['avatar']): ?>
            <img src="uploads/<?= htmlspecialchars($u['avatar']) ?>" width="40" class="rounded-circle">
          <?php else: ?>
            <span class="text-muted">—</span>
          <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($u['username']) ?></td>
        <td><?= htmlspecialchars($u['name']) ?></td>
        <td><?= htmlspecialchars($u['phone']) ?></td>
        <td><?= htmlspecialchars($u['email']) ?></td>
        <td><?= htmlspecialchars($u['group_name'] ?? '—') ?></td>
        <td>
          <?php if ($u['is_active']): ?>
            <span class="badge bg-success">مفعل</span>
          <?php else: ?>
            <span class="badge bg-danger">موقوف</span>
          <?php endif; ?>
        </td>
        <td>
          <a href="user_form.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-warning">✏️</a>
          <a href="toggle_user.php?id=<?= $u['id'] ?>" class="btn btn-sm <?= $u['is_active']?'btn-danger':'btn-success' ?>">
            <?= $u['is_active']?'إيقاف':'تفعيل' ?>
          </a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<script>
  const body = document.body;
  const darkSwitch = document.getElementById("darkSwitch");
  if (localStorage.getItem("darkMode") === "true") {
    body.classList.add("dark"); darkSwitch.textContent = "☀️";
  }
  darkSwitch.addEventListener("click", () => {
    body.classList.toggle("dark");
    const isDark = body.classList.contains("dark");
    localStorage.setItem("darkMode", isDark);
    darkSwitch.textContent = isDark ? "☀️" : "🌙";
  });
</script>

<style>
  body.dark { background:#121212; color:#eee; }
  body.dark .table { color:#fff; }
  body.dark .bg-dark { background:#000 !important; }
</style>
</body>
</html>
