<?php
require_once __DIR__.'/_init.php';
$title='أداء الأقسام/الفئات';
include __DIR__.'/_layout_top.php';

$df = param('date_from','');
$dt = param('date_to','');
$branch_id = param('branch_id','');
$brs = branches($pdo);

$hasSales = hasTable($pdo,'sales');
$hasItems = hasTable($pdo,'sale_items');

if(!$hasSales || !$hasItems){
  echo '<div class="panel p-3 alert alert-warning">يتطلب التقرير وجود <code>sales</code> و <code>sale_items</code>.</div>';
  include __DIR__.'/_layout_bottom.php';
  exit;
}

/** دوال مساعدة */
function firstExistingColumn($pdo, $table, $candidates){
  foreach ($candidates as $c){
    if (hasColumn($pdo,$table,$c)) return $c;
  }
  return null;
}

/** 1) التاريخ والفلترة الأساسية من sales */
$dateCol = firstExistingColumn($pdo,'sales',['created_at','invoice_date','sale_date','date']);
$w = [];
$p = [];
if ($dateCol){
  if ($df!==''){ $w[]="DATE(s.`$dateCol`) >= :df"; $p[':df']=$df; }
  if ($dt!==''){ $w[]="DATE(s.`$dateCol`) <= :dt"; $p[':dt']=$dt; }
}
if (hasColumn($pdo,'sales','deleted_at')) $w[]="s.deleted_at IS NULL";
if ($branch_id!=='' && hasColumn($pdo,'sales','branch_id')){ $w[]="s.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
$wsql = $w ? 'WHERE '.implode(' AND ',$w) : '';

/** 2) أعمدة البنود: كمية/سعر/خصم/ضريبة/إجمالي السطر */
$qtyCol          = firstExistingColumn($pdo,'sale_items',['quantity','qty','qty_sold','quantity_sold','pieces','units','count']);
$unitPriceCol    = firstExistingColumn($pdo,'sale_items',['unit_price','price','unitprice','sale_price','selling_price','unit_cost']);
$lineDiscountCol = firstExistingColumn($pdo,'sale_items',['line_discount','discount','discount_amount','line_discount_amount']);
$taxAmtCol       = firstExistingColumn($pdo,'sale_items',['line_tax_amount','tax_amount','taxvalue']);
$taxRateCol      = firstExistingColumn($pdo,'sale_items',['line_tax_rate','tax_rate','vat_rate']);
$lineTotalCol    = firstExistingColumn($pdo,'sale_items',['line_total','row_total','line_total_amount','net_line_total','line_net_total','subtotal']);

/** تعبير مجموع الكمية */
$qtySumExpr = $qtyCol ? "SUM(i.`$qtyCol`)" : "COUNT(*)";

/** تعبير الإيراد */
if ($lineTotalCol){
  $revExpr = "i.`$lineTotalCol`";
} else {
  $qExpr  = $qtyCol ? "i.`$qtyCol`" : "1";
  $pExpr  = $unitPriceCol ? "i.`$unitPriceCol`" : "0";
  $gross  = "($qExpr*$pExpr)";
  $disc   = $lineDiscountCol ? "i.`$lineDiscountCol`" : "0";
  $base   = "($gross - $disc)";
  if ($taxAmtCol){
    $tax = "i.`$taxAmtCol`";
  } elseif ($taxRateCol){
    $tax = "($base * (i.`$taxRateCol`/100))";
  } else {
    $tax = "0";
  }
  $revExpr = "($base + $tax)";
}

/** فلتر حذف منطقي على عناصر الفاتورة إن وُجد */
$itemDeleteFilter = '';
if (hasColumn($pdo,'sale_items','deleted_at')){
  $itemDeleteFilter = $wsql ? " AND i.deleted_at IS NULL" : " WHERE i.deleted_at IS NULL";
}

/** 3) تحديد مسار الربط: variant أو مباشرة product */
$hasVariantsTable = hasTable($pdo,'product_variants');
$useVariant = $hasVariantsTable && hasColumn($pdo,'sale_items','variant_id') && hasColumn($pdo,'product_variants','id');

/** 4) تجهيز معلومات الأصناف (الاسم/الربط) */
$nameCol = firstExistingColumn($pdo,'products',['name_ar','name','title_ar','title','product_name','name_en']);

/** 5) إعداد معلومات الفئات (categories) إن وُجدت */
$hasCategories = hasTable($pdo,'categories');
$categoryNameCol = $hasCategories ? firstExistingColumn($pdo,'categories',['name_ar','name','title_ar','title','CategoryName']) : null;
$categoryIdCol   = $hasCategories ? firstExistingColumn($pdo,'categories',['id','category_id','CategoryID','cat_id']) : null;

/** محاولة العثور على مفتاح الفئة في جداولنا (تفضيل products ثم variants ثم sale_items) */
$prodCatFK    = firstExistingColumn($pdo,'products',['category_id','cat_id','categoryId','CategoryID']);
$variantCatFK = $useVariant ? firstExistingColumn($pdo,'product_variants',['category_id','cat_id','categoryId','CategoryID']) : null;
$itemCatFK    = firstExistingColumn($pdo,'sale_items',['category_id','cat_id','categoryId','CategoryID']);

$canJoinCategories =
  $hasCategories &&
  $categoryNameCol && $categoryIdCol &&
  ($prodCatFK || $variantCatFK || $itemCatFK);

/** 6) بناء SQL */
if ($useVariant){
  // join: sale_items -> sales -> variants -> products
  if ($canJoinCategories){
    // أي عمود سنستعمله للربط؟
    if ($prodCatFK){
      $joinOn = "c.`$categoryIdCol` = p.`$prodCatFK`";
    } elseif ($variantCatFK){
      $joinOn = "c.`$categoryIdCol` = v.`$variantCatFK`";
    } else { // $itemCatFK
      $joinOn = "c.`$categoryIdCol` = i.`$itemCatFK`";
    }

    $sql = "
      SELECT
        COALESCE(c.`$categoryNameCol`,'غير مصنف') AS category,
        $qtySumExpr AS qty,
        SUM($revExpr) AS revenue
      FROM sale_items i
      JOIN sales s ON s.id = i.sale_id
      JOIN product_variants v ON v.id = i.variant_id
      JOIN products p ON p.id = v.product_id
      LEFT JOIN categories c ON $joinOn
      $wsql$itemDeleteFilter
      GROUP BY category
      ORDER BY revenue DESC
    ";
  } else {
    // لا يمكن الربط بفئات -> نجمع على اسم المنتج كبديل
    $prodName = $nameCol ? "p.`$nameCol`" : "CONCAT('Product #', p.id)";
    $sql = "
      SELECT
        $prodName AS category,
        $qtySumExpr AS qty,
        SUM($revExpr) AS revenue
      FROM sale_items i
      JOIN sales s ON s.id = i.sale_id
      JOIN product_variants v ON v.id = i.variant_id
      JOIN products p ON p.id = v.product_id
      $wsql$itemDeleteFilter
      GROUP BY category
      ORDER BY revenue DESC
    ";
  }
} else {
  // لا يوجد variant_id -> نربط مباشرة بـ products
  if (!hasColumn($pdo,'sale_items','product_id')){
    echo '<div class="panel p-3 alert alert-danger">لا يوجد عمود <code>variant_id</code> ولا <code>product_id</code> في <code>sale_items</code> لربط الأصناف.</div>';
    include __DIR__.'/_layout_bottom.php';
    exit;
  }

  if ($canJoinCategories){
    if ($prodCatFK){
      $joinOn = "c.`$categoryIdCol` = p.`$prodCatFK`";
    } elseif ($itemCatFK){
      $joinOn = "c.`$categoryIdCol` = i.`$itemCatFK`";
    } else {
      $joinOn = "0"; // احتياطي لن يصل هنا منطقياً
    }

    $sql = "
      SELECT
        COALESCE(c.`$categoryNameCol`,'غير مصنف') AS category,
        $qtySumExpr AS qty,
        SUM($revExpr) AS revenue
      FROM sale_items i
      JOIN sales s ON s.id = i.sale_id
      JOIN products p ON p.id = i.product_id
      LEFT JOIN categories c ON $joinOn
      $wsql$itemDeleteFilter
      GROUP BY category
      ORDER BY revenue DESC
    ";
  } else {
    $prodName = $nameCol ? "p.`$nameCol`" : "CONCAT('Product #', p.id)";
    $sql = "
      SELECT
        $prodName AS category,
        $qtySumExpr AS qty,
        SUM($revExpr) AS revenue
      FROM sale_items i
      JOIN sales s ON s.id = i.sale_id
      JOIN products p ON p.id = i.product_id
      $wsql$itemDeleteFilter
      GROUP BY category
      ORDER BY revenue DESC
    ";
  }
}

$st = $pdo->prepare($sql);
$st->execute($p);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

/** تصدير CSV */
if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('category_performance.csv',['category','qty','revenue'],$rows);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3">
      <label class="form-label">من</label>
      <input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">إلى</label>
      <input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?>
          <option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>>
            <?= htmlspecialchars($nm) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>
  <div class="table-responsive">
    <table class="table table-hover text-center align-middle">
      <thead class="table-light">
        <tr><th>القسم/الفئة</th><th>الكمية</th><th>الإيراد</th></tr>
      </thead>
      <tbody>
        <?php if(!$rows): ?>
          <tr><td colspan="3" class="text-muted">لا بيانات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr>
            <td class="text-start"><?= htmlspecialchars($r['category'] ?? 'غير مصنف') ?></td>
            <td><?= (int)$r['qty'] ?></td>
            <td class="fw-bold"><?= money($r['revenue']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
