<?php
require_once __DIR__.'/_init.php';
$title='ترتيب العملاء';
include __DIR__.'/_layout_top.php';

$df=param('date_from',''); $dt=param('date_to',''); $branch_id=param('branch_id',''); $limit=(int)(param('limit','100')?:100);
$brs=branches($pdo);

$hasSales=hasTable($pdo,'sales'); if(!$hasSales){ echo '<div class="panel p-3 alert alert-warning">يتطلب التقرير جدول <code>sales</code>.</div>'; include __DIR__.'/_layout_bottom.php'; exit; }
$dateCol=null; foreach(['created_at','invoice_date','sale_date'] as $c){ if(hasColumn($pdo,'sales',$c)){ $dateCol=$c; break; } }

$w=["s.deleted_at IS NULL", "s.customer_id IS NOT NULL"]; $p=[];
if($dateCol){
  if($df!==''){ $w[]="DATE(s.`$dateCol`) >= :df"; $p[':df']=$df; }
  if($dt!==''){ $w[]="DATE(s.`$dateCol`) <= :dt"; $p[':dt']=$dt; }
}
if($branch_id!==''){ $w[]="s.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
$wsql='WHERE '.implode(' AND ',$w);

// أسماء العملاء
$nameCols=['name','full_name','customer_name','CustomerName'];
$best='name'; foreach($nameCols as $c){ if(hasColumn($pdo,'customers',$c)){ $best=$c; break; } }

$sql="SELECT s.customer_id, COUNT(*) AS visits, SUM(s.total) AS total
      FROM sales s $wsql
      GROUP BY s.customer_id
      ORDER BY total DESC
      LIMIT $limit";
$st=$pdo->prepare($sql); $st->execute($p); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

$ids=array_column($rows,'customer_id');
$names=[]; if($ids){
  $in=implode(',', array_fill(0,count($ids),'?'));
  $nm=$pdo->prepare("SELECT id, `$best` AS nm FROM customers WHERE id IN ($in)");
  $nm->execute($ids);
  foreach($nm->fetchAll(PDO::FETCH_ASSOC) as $r){ $names[(int)$r['id']] = $r['nm']; }
}

if (isset($_GET['export']) && $_GET['export']==='csv'){
  $out=[]; foreach($rows as $r){ $out[]=['customer'=>$names[(int)$r['customer_id']] ?? ('#'.$r['customer_id']),'visits'=>$r['visits'],'total'=>$r['total']]; }
  csv_export('customers_ranking.csv',['customer','visits','total'],$out);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">من</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>"></div>
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id"><option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!==''&&(int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>

  <div class="table-responsive">
    <table class="table table-hover text-center align-middle">
      <thead class="table-light"><tr><th>#</th><th>العميل</th><th>عدد الزيارات</th><th>إجمالي الشراء</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="4" class="text-muted">لا بيانات.</td></tr>
        <?php else: $i=1; foreach($rows as $r): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td class="text-start"><?= htmlspecialchars($names[(int)$r['customer_id']] ?? ('#'.$r['customer_id'])) ?></td>
            <td><?= (int)$r['visits'] ?></td>
            <td class="fw-bold"><?= money($r['total']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
