<?php
require_once __DIR__.'/_init.php';
$title='تحليل طرق الدفع';
include __DIR__.'/_layout_top.php';

$df = param('date_from','');
$dt = param('date_to','');
$branch_id = param('branch_id','');
$brs = branches($pdo);

$hasSales = hasTable($pdo,'sales');
$hasDaily = hasTable($pdo,'dailyshiftsales');

$data = [];

/** دوال مساعدة صغيرة */
function firstExistingColumn($pdo, $table, $candidates){
  foreach ($candidates as $c){
    if (hasColumn($pdo,$table,$c)) return $c;
  }
  return null;
}

/** خرائط أعمدة المبالغ -> اسم الطريقة (للوضع الذي لا يوجد فيه عمود طريقة دفع موحد) */
$amountColsMap = [
  // نقدي
  'cash_amount' => 'cash', 'cash' => 'cash',
  // بطاقات / نقاط بيع
  'card_amount' => 'card', 'card' => 'card', 'pos_amount' => 'card',
  'visa_amount' => 'card', 'master_amount' => 'card', 'mada_amount' => 'card',
  // بنك/حوالة
  'bank_amount' => 'bank', 'transfer_amount' => 'bank',
  'bank_transfer_amount' => 'bank', 'wire_amount' => 'bank',
  // محافظ/مدفوعات رقمية
  'wallet_amount' => 'wallet', 'mobile_amount' => 'wallet', 'stc_pay_amount' => 'wallet',
  'paypal_amount' => 'paypal',
  // شيكات/قسائم/هدايا
  'cheque_amount' => 'cheque', 'check_amount' => 'cheque',
  'voucher_amount' => 'voucher', 'coupon_amount' => 'voucher', 'giftcard_amount' => 'voucher',
  // أخرى
  'other_amount' => 'other'
];

if ($hasSales){
  /** تحديد أعمدة التاريخ والفرع والحذف المنطقي إن وجدت */
  $dateCol = firstExistingColumn($pdo,'sales',['created_at','invoice_date','sale_date','date']);
  $w = [];
  $p = [];
  if ($dateCol){
    if ($df!==''){ $w[]="DATE(s.`$dateCol`) >= :df"; $p[':df']=$df; }
    if ($dt!==''){ $w[]="DATE(s.`$dateCol`) <= :dt"; $p[':dt']=$dt; }
  }
  if (hasColumn($pdo,'sales','deleted_at')) $w[]="s.deleted_at IS NULL";
  if ($branch_id!=='' && hasColumn($pdo,'sales','branch_id')){ $w[]="s.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
  $wsql = $w ? 'WHERE '.implode(' AND ',$w) : '';

  /** A) وجود عمود طريقة دفع موحّد */
  $salesMethodCol = firstExistingColumn($pdo,'sales',['pay_method','payment_method','payment_type','method','pay_type']);
  // عمود المبلغ المراد جمعه لكل مجموعة
  $salesAmountCol = firstExistingColumn($pdo,'sales',['paid','amount_paid','total_paid','received_amount']);
  if (!$salesAmountCol){
    // كاحتياط: استخدم إجمالي الفاتورة إن وُجد
    $salesAmountCol = firstExistingColumn($pdo,'sales',['total','grand_total','net_total','total_amount']);
  }

  if ($salesMethodCol && $salesAmountCol){
    $st = $pdo->prepare("
      SELECT LOWER(TRIM(s.`$salesMethodCol`)) AS method, COALESCE(SUM(s.`$salesAmountCol`),0) AS amt
      FROM sales s
      $wsql
      GROUP BY method
      ORDER BY amt DESC
    ");
    $st->execute($p);
    foreach($st->fetchAll(PDO::FETCH_ASSOC) as $r){
      $key = $r['method'] ?: 'other';
      $data[$key] = ($data[$key] ?? 0) + (float)$r['amt'];
    }
  } else {
    /** B) لا يوجد عمود طريقة موحّد -> نجمع أعمدة المبالغ المنفصلة إن وُجدت */
    $selectParts = [];
    $labels = [];
    foreach ($amountColsMap as $col=>$label){
      if (hasColumn($pdo,'sales',$col)){
        $selectParts[] = "COALESCE(SUM(s.`$col`),0) AS `$col`";
        $labels[$col] = $label;
      }
    }
    if ($selectParts){
      $sql = "SELECT ".implode(", ", $selectParts)." FROM sales s $wsql";
      $st = $pdo->prepare($sql);
      $st->execute($p);
      $row = $st->fetch(PDO::FETCH_ASSOC) ?: [];
      foreach ($labels as $col=>$label){
        $amt = isset($row[$col]) ? (float)$row[$col] : 0.0;
        if ($amt != 0){
          $data[$label] = ($data[$label] ?? 0) + $amt;
        }
      }
    }
  }
}

/** fallback إلى dailyshiftsales لو ما قدرناش نطلع بيانات من sales */
if (!$data && $hasDaily){
  // تحديد التاريخ والفرع والحذف المنطقي
  $dailyDateCol = firstExistingColumn($pdo,'dailyshiftsales',['created_at','date']);
  $w = [];
  $p = [];
  if ($dailyDateCol){
    if ($df!==''){ $w[]="DATE(`$dailyDateCol`) >= :df"; $p[':df']=$df; }
    if ($dt!==''){ $w[]="DATE(`$dailyDateCol`) <= :dt"; $p[':dt']=$dt; }
  }
  if (hasColumn($pdo,'dailyshiftsales','deleted_at')) $w[]="deleted_at IS NULL";
  if ($branch_id!=='' && hasColumn($pdo,'dailyshiftsales','branch_id')){ $w[]="branch_id=:bid"; $p[':bid']=(int)$branch_id; }
  $wsql = $w ? 'WHERE '.implode(' AND ',$w) : '';

  // 1) طريقة دفع موحّدة في dailyshiftsales؟
  $dailyMethodCol = firstExistingColumn($pdo,'dailyshiftsales',['pay_method','payment_method','method','pay_type','payment_type']);
  $dailyAmountCol = firstExistingColumn($pdo,'dailyshiftsales',['amount','amt','value']);

  if ($dailyMethodCol && $dailyAmountCol){
    $st = $pdo->prepare("
      SELECT LOWER(TRIM(`$dailyMethodCol`)) AS method, COALESCE(SUM(`$dailyAmountCol`),0) AS amt
      FROM dailyshiftsales
      $wsql
      GROUP BY method
      ORDER BY amt DESC
    ");
    $st->execute($p);
    foreach($st->fetchAll(PDO::FETCH_ASSOC) as $r){
      $key = $r['method'] ?: 'other';
      $data[$key] = ($data[$key] ?? 0) + (float)$r['amt'];
    }
  } else {
    // 2) نجمع أعمدة مبالغ منفصلة في dailyshiftsales إن وجدت
    $selectParts = [];
    $labels = [];
    foreach ($amountColsMap as $col=>$label){
      if (hasColumn($pdo,'dailyshiftsales',$col)){
        $selectParts[] = "COALESCE(SUM(`$col`),0) AS `$col`";
        $labels[$col] = $label;
      }
    }
    if ($selectParts){
      $sql = "SELECT ".implode(", ", $selectParts)." FROM dailyshiftsales $wsql";
      $st = $pdo->prepare($sql);
      $st->execute($p);
      $row = $st->fetch(PDO::FETCH_ASSOC) ?: [];
      foreach ($labels as $col=>$label){
        $amt = isset($row[$col]) ? (float)$row[$col] : 0.0;
        if ($amt != 0){
          $data[$label] = ($data[$label] ?? 0) + $amt;
        }
      }
    }
  }
}

/** تجهيز الخرج */
$rowsOut=[]; $total=0.0;
foreach($data as $m=>$amt){ $rowsOut[]=['method'=>$m, 'amount'=>(float)$amt]; $total += (float)$amt; }
usort($rowsOut, fn($a,$b)=> $b['amount'] <=> $a['amount']);

if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('payments_breakdown.csv',['method','amount'],$rowsOut);
}
?>
<div class="panel p-3">
  <?php if(!$hasSales && !$hasDaily): ?>
    <div class="alert alert-warning">لا توجد جداول مناسبة لاستخلاص طرق الدفع.</div>
  <?php endif; ?>
  <form class="row g-2 align-items-end">
    <div class="col-md-3">
      <label class="form-label">من</label>
      <input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">إلى</label>
      <input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?>
          <option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>>
            <?= htmlspecialchars($nm) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>

  <hr>
  <div class="table-responsive">
    <table class="table table-hover text-center">
      <thead class="table-light">
        <tr><th>طريقة الدفع</th><th>القيمة</th><th>%</th></tr>
      </thead>
      <tbody>
      <?php if(!$rowsOut): ?>
        <tr><td colspan="3" class="text-muted">لا بيانات.</td></tr>
      <?php else: ?>
        <?php foreach($rowsOut as $r): $pct = $total ? round(100*$r['amount']/$total,2) : 0; ?>
          <tr>
            <td class="text-start text-capitalize"><?= htmlspecialchars($r['method']) ?></td>
            <td class="fw-bold"><?= money($r['amount']) ?></td>
            <td><?= $pct ?>%</td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
