<?php
require_once __DIR__ . '/_init.php';
$title='تنبيهات إعادة الطلب'; include __DIR__ . '/_layout_top.php';
$branch_id = param('branch_id',''); $brs = branches($pdo);

$where = ["s.quantity <= s.min_quantity"];
$params=[];
if ($branch_id!==''){ $where[]="s.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
$whereSQL = 'WHERE '.implode(' AND ',$where);
$sql="SELECT p.name_ar AS product_name, v.sku, b.BranchName, s.quantity, s.min_quantity, (s.min_quantity - s.quantity) AS shortage
      FROM product_variant_stock s
      JOIN product_variants v ON v.id=s.variant_id
      JOIN products p ON p.id=v.product_id
      LEFT JOIN Branches b ON b.BranchID=s.branch_id
      $whereSQL
      ORDER BY shortage DESC, p.name_ar";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);
if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('reorder_alerts.csv',['product_name','sku','BranchName','quantity','min_quantity','shortage'],$rows);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-8 d-flex gap-2">
      <button class="btn btn-brand"><i class="fa-solid fa-rotate"></i> تحديث</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>"><i class="fa-solid fa-file-csv"></i> CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()"><i class="fa-solid fa-print"></i> طباعة</button>
    </div>
  </form><hr>
  <div class="table-responsive">
    <table class="table table-hover align-middle text-center">
      <thead class="table-light"><tr><th>الصنف</th><th>SKU</th><th>الفرع</th><th>المخزون</th><th>الحد</th><th>العجز</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="6" class="text-muted">لا توجد أصناف تحتاج طلب.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr class="table-warning">
            <td class="text-start"><?= htmlspecialchars($r['product_name']) ?></td>
            <td><?= htmlspecialchars($r['sku']) ?></td>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td><strong><?= (int)$r['quantity'] ?></strong></td>
            <td><?= (int)$r['min_quantity'] ?></td>
            <td class="text-danger fw-bold"><?= (int)$r['shortage'] ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_bottom.php';
