<?php
require_once __DIR__.'/_init.php';
$title='أعلى المنتجات بيعًا';
include __DIR__.'/_layout_top.php';

$df = param('date_from','');
$dt = param('date_to','');
$branch_id = param('branch_id','');
$limit = (int)(param('limit','50') ?: 50);
$brs = branches($pdo);

$hasSales = hasTable($pdo,'sales');
$hasItems = hasTable($pdo,'sale_items');

if(!$hasSales || !$hasItems){
  echo '<div class="panel p-3 alert alert-warning">يتطلب التقرير وجود <code>sales</code> و <code>sale_items</code>.</div>';
  include __DIR__.'/_layout_bottom.php';
  exit;
}

/** دوال مساعدة صغيرة */
function firstExistingColumn($pdo, $table, $candidates){
  foreach ($candidates as $c){
    if (hasColumn($pdo,$table,$c)) return $c;
  }
  return null;
}

/** عمود التاريخ من sales */
$dateCol = firstExistingColumn($pdo,'sales',['created_at','invoice_date','sale_date','date']);

/** شروط WHERE لمعاملات التاريخ/الفرع والحذف */
$w = [];
$p = [];
if ($dateCol){
  if ($df!==''){ $w[] = "DATE(s.`$dateCol`) >= :df"; $p[':df'] = $df; }
  if ($dt!==''){ $w[] = "DATE(s.`$dateCol`) <= :dt"; $p[':dt'] = $dt; }
}
if (hasColumn($pdo,'sales','deleted_at')) $w[] = "s.deleted_at IS NULL";
if ($branch_id!=='' && hasColumn($pdo,'sales','branch_id')){ $w[]="s.branch_id=:bid"; $p[':bid']=(int)$branch_id; }
$wsql = $w ? 'WHERE '.implode(' AND ',$w) : '';

/** اكتشاف أعمدة الكمية/السعر/الخصم/الضريبة/إجمالي السطر في sale_items */
$qtyCol         = firstExistingColumn($pdo,'sale_items',['quantity','qty','qty_sold','quantity_sold','pieces','units','count']);
$unitPriceCol   = firstExistingColumn($pdo,'sale_items',['unit_price','price','unitprice','sale_price','selling_price','unit_cost']);
$lineDiscountCol= firstExistingColumn($pdo,'sale_items',['line_discount','discount','discount_amount','line_discount_amount']);
$taxAmtCol      = firstExistingColumn($pdo,'sale_items',['line_tax_amount','tax_amount','taxvalue']);
$taxRateCol     = firstExistingColumn($pdo,'sale_items',['line_tax_rate','tax_rate','vat_rate']);
$lineTotalCol   = firstExistingColumn($pdo,'sale_items',['line_total','row_total','line_total_amount','net_line_total','line_net_total','subtotal']);

/** تعبير كمية المبيعات */
$qtyExprSum = $qtyCol ? "SUM(i.`$qtyCol`)" : "COUNT(*)";

/** تعبير الإيراد */
if ($lineTotalCol){
  // لو موجود إجمالي السطر، نستعمله مباشرة
  $revExpr = "i.`$lineTotalCol`";
} else {
  // نحسب: (الكمية*السعر - الخصم) + الضريبة
  $qExpr   = $qtyCol       ? "i.`$qtyCol`" : "1";
  $prExpr  = $unitPriceCol ? "i.`$unitPriceCol`" : "0";
  $gross   = "($qExpr*$prExpr)";
  $disc    = $lineDiscountCol ? "i.`$lineDiscountCol`" : "0";
  $base    = "($gross - $disc)";
  if ($taxAmtCol){
    $tax = "i.`$taxAmtCol`";
  } elseif ($taxRateCol){
    $tax = "($base * (i.`$taxRateCol`/100))";
  } else {
    $tax = "0";
  }
  $revExpr = "($base + $tax)";
}

/** فلتر حذف منطقي على عناصر الفاتورة إن وُجد */
$itemDeleteFilter = '';
if (hasColumn($pdo,'sale_items','deleted_at')){
  $itemDeleteFilter = $wsql ? " AND i.deleted_at IS NULL" : " WHERE i.deleted_at IS NULL";
}

/** هل لدينا variant_id أم فقط product_id؟ */
$hasVariantsTable = hasTable($pdo,'product_variants');
$useVariant = $hasVariantsTable && hasColumn($pdo,'sale_items','variant_id') && hasColumn($pdo,'product_variants','id');

/** أعمدة الاسم و SKU */
$nameCol = firstExistingColumn($pdo,'products',['name_ar','name','title_ar','title','product_name','name_en']);
$variantSkuCol = $useVariant ? firstExistingColumn($pdo,'product_variants',['sku','code','barcode']) : null;
$productSkuCol = $useVariant ? null : firstExistingColumn($pdo,'products',['sku','code','barcode']);

/** بناء SQL حسب المسار */
if ($useVariant){
  // join via variant_id -> product_variants -> products
  $idSelect = "v.id AS variant_id";
  $skuSelect = $variantSkuCol ? "v.`$variantSkuCol` AS sku" : "NULL AS sku";
  $nameSelect = $nameCol ? "p.`$nameCol` AS product_name" : "CONCAT('Product #', p.id) AS product_name";

  $sql = "
    SELECT
      $idSelect,
      $skuSelect,
      $nameSelect,
      $qtyExprSum AS qty,
      SUM($revExpr) AS revenue
    FROM sale_items i
    JOIN sales s ON s.id = i.sale_id
    JOIN product_variants v ON v.id = i.variant_id
    JOIN products p ON p.id = v.product_id
    $wsql$itemDeleteFilter
    GROUP BY v.id, sku, product_name
    ORDER BY qty DESC
    LIMIT $limit
  ";
} else {
  // لا يوجد variant_id -> نربط مباشرة على products
  $idSelect = "p.id AS product_id";
  $skuSelect = $productSkuCol ? "p.`$productSkuCol` AS sku" : "NULL AS sku";
  $nameSelect = $nameCol ? "p.`$nameCol` AS product_name" : "CONCAT('Product #', p.id) AS product_name";

  // تأكد من وجود product_id في sale_items
  if (!hasColumn($pdo,'sale_items','product_id')){
    echo '<div class="panel p-3 alert alert-danger">لا يوجد عمود <code>variant_id</code> ولا <code>product_id</code> في <code>sale_items</code> لربط الأصناف.</div>';
    include __DIR__.'/_layout_bottom.php';
    exit;
  }

  $sql = "
    SELECT
      $idSelect,
      $skuSelect,
      $nameSelect,
      $qtyExprSum AS qty,
      SUM($revExpr) AS revenue
    FROM sale_items i
    JOIN sales s ON s.id = i.sale_id
    JOIN products p ON p.id = i.product_id
    $wsql$itemDeleteFilter
    GROUP BY p.id, sku, product_name
    ORDER BY qty DESC
    LIMIT $limit
  ";
}

$st = $pdo->prepare($sql);
$st->execute($p);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('top_products.csv',['product_name','sku','qty','revenue'],$rows);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3">
      <label class="form-label">من</label>
      <input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($df) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">إلى</label>
      <input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($dt) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?>
          <option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>>
            <?= htmlspecialchars($nm) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form>
  <hr>

  <div class="table-responsive">
    <table class="table table-striped text-center align-middle">
      <thead class="table-light">
        <tr><th>#</th><th>الصنف</th><th>SKU</th><th>كمية</th><th>إيراد تقديري</th></tr>
      </thead>
      <tbody>
        <?php if(!$rows): ?>
          <tr><td colspan="5" class="text-muted">لا بيانات.</td></tr>
        <?php else: $i=1; foreach($rows as $r): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td class="text-start"><?= htmlspecialchars($r['product_name']) ?></td>
            <td><?= htmlspecialchars($r['sku']) ?></td>
            <td class="fw-bold"><?= (int)$r['qty'] ?></td>
            <td><?= money($r['revenue']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__.'/_layout_bottom.php';
