<?php
require_once __DIR__ . '/../../core/auth.php';
require_login();
$pdo = db();

/* ===== Helpers ===== */
function hasTable(PDO $pdo, string $table): bool {
  $st = $pdo->prepare("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = ?");
  $st->execute([$table]);
  return (int)$st->fetchColumn() > 0;
}
function hasColumn(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SELECT COUNT(*) FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = ? AND column_name = ?");
  $st->execute([$table,$col]);
  return (int)$st->fetchColumn() > 0;
}
function money($n){ return number_format((float)$n, 2); }
function param($key, $default=null){ return isset($_GET[$key]) ? trim((string)$_GET[$key]) : $default; }
function csv_export(string $filename, array $headers, array $rows){
  header('Content-Type: text/csv; charset=UTF-8');
  header('Content-Disposition: attachment; filename="'.$filename.'"');
  $out = fopen('php://output', 'w');
  fprintf($out, chr(0xEF).chr(0xBB).chr(0xBF)); // BOM UTF-8
  fputcsv($out, $headers);
  foreach ($rows as $r){
    $line = [];
    foreach ($headers as $h){ $line[] = $r[$h] ?? ''; }
    fputcsv($out, $line);
  }
  fclose($out); exit;
}
function branches(PDO $pdo): array {
  try{
    return $pdo->query("SELECT BranchID, BranchName FROM Branches WHERE IsActive=1 ORDER BY BranchName")->fetchAll(PDO::FETCH_KEY_PAIR);
  }catch(Throwable $e){ return []; }
}
function suppliers(PDO $pdo): array {
  $nameCol = 'name';
  foreach (['name','SupplierName','supplier_name','company_name','CompanyName'] as $c){
    if (hasColumn($pdo,'suppliers',$c)) { $nameCol=$c; break; }
  }
  try{
    return $pdo->query("SELECT id, `{$nameCol}` AS name FROM suppliers ORDER BY `{$nameCol}`")->fetchAll(PDO::FETCH_KEY_PAIR);
  }catch(Throwable $e){ return []; }
}
function categories(PDO $pdo): array {
  try{
    return $pdo->query("SELECT id, name_ar FROM categories ORDER BY name_ar")->fetchAll(PDO::FETCH_KEY_PAIR);
  }catch(Throwable $e){ return []; }
}
$user = current_user();
