<?php
require_once __DIR__ . '/_init.php';
$title='حركة المخزون'; include __DIR__ . '/_layout_top.php';

$branch_id = param('branch_id',''); $ref = param('ref_type',''); $date_from = param('date_from',''); $date_to = param('date_to','');
$brs = branches($pdo);

$where=[]; $params=[];
if ($branch_id!==''){ $where[]="m.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
if ($ref!==''){ $where[]="m.ref_type=:rt"; $params[':rt']=$ref; }
if ($date_from!==''){ $where[]="DATE(m.created_at)>=:df"; $params[':df']=$date_from; }
if ($date_to!==''){ $where[]="DATE(m.created_at)<=:dt"; $params[':dt']=$date_to; }
$whereSQL = $where? 'WHERE '.implode(' AND ',$where) : '';

$hasCreated = hasColumn($pdo,'inventory_movements','created_at');
$createdCol = $hasCreated ? 'm.created_at' : 'NULL';

$sql="SELECT $createdCol AS created_at, b.BranchName, v.sku, m.qty_change, m.unit_cost, m.ref_type, m.ref_id
      FROM inventory_movements m
      LEFT JOIN Branches b ON b.BranchID=m.branch_id
      LEFT JOIN product_variants v ON v.id=m.variant_id
      $whereSQL
      ORDER BY m.id DESC LIMIT 2000";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);

$sum_in=$sum_out=0; foreach($rows as $r){ $q=(int)$r['qty_change']; if($q>0) $sum_in+=$q; else $sum_out+=abs($q); }
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3"><label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">الكل</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select></div>
    <div class="col-md-3"><label class="form-label">نوع المرجع</label>
      <select class="form-select" name="ref_type">
        <option value="">الكل</option>
        <?php foreach (['purchase','purchase_return','transfer_out','transfer_in','sale','sales_return','stock_count'] as $t): ?>
          <option value="<?= $t ?>" <?= $ref===$t?'selected':''; ?>><?= $t ?></option>
        <?php endforeach; ?>
      </select></div>
    <div class="col-md-3"><label class="form-label">من تاريخ</label><input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from) ?>"></div>
    <div class="col-md-3"><label class="form-label">إلى تاريخ</label><input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to) ?>"></div>
    <div class="col-12 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form><hr>
  <div class="d-flex gap-3 mb-2">
    <span class="badge bg-success">وارد: <?= (int)$sum_in ?></span>
    <span class="badge bg-danger">صادر: <?= (int)$sum_out ?></span>
  </div>
  <div class="table-responsive">
    <table class="table table-striped text-center align-middle">
      <thead class="table-light"><tr><th>التاريخ</th><th>الفرع</th><th>SKU</th><th>كمية ±</th><th>تكلفة</th><th>المرجع</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="6" class="text-muted">لا توجد حركات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr class="<?= ((int)$r['qty_change']<0)?'table-danger':'' ?>">
            <td><?= htmlspecialchars($r['created_at'] ?? '—') ?></td>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td><?= htmlspecialchars($r['sku'] ?? '-') ?></td>
            <td class="fw-bold"><?= (int)$r['qty_change'] ?></td>
            <td><?= money($r['unit_cost']) ?></td>
            <td><?= htmlspecialchars(($r['ref_type'] ?? '').'#'.(string)($r['ref_id'] ?? '')) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_bottom.php';
