<?php
require_once __DIR__.'/_init.php';
$title = 'تحليل فروقات الجرد';
include __DIR__.'/_layout_top.php';

/* ========= حماية في حال الجداول لسه مش موجودة ========= */
$hasSC  = hasTable($pdo, 'stock_counts');
$hasSCI = hasTable($pdo, 'stock_count_items');

if (!$hasSC || !$hasSCI) {
  echo '<div class="panel p-3 alert alert-warning">
          التقرير يحتاج وجود جدولي <code>stock_counts</code> و <code>stock_count_items</code>.
          بمجرد إنشائهم هتشتغل الصفحة تلقائيًا.
        </div>';
  include __DIR__.'/_layout_bottom.php'; exit;
}

/* ========= اكتشاف أسماء الأعمدة ========= */
// تاريخ جلسة الجرد في stock_counts
$scDateCol = null;
foreach (['count_date','counted_at','created_at','date'] as $c) {
  if (hasColumn($pdo, 'stock_counts', $c)) { $scDateCol = $c; break; }
}
// حالة الجلسة
$scStatusCol = hasColumn($pdo,'stock_counts','status') ? 'status' : null;
// ملاحظات
$scNotesCol  = hasColumn($pdo,'stock_counts','notes')  ? 'notes'  : null;

// مفاتيح items
$ciCountIdCol = null; foreach(['count_id','stock_count_id','sc_id','header_id'] as $c){ if(hasColumn($pdo,'stock_count_items',$c)){ $ciCountIdCol=$c; break; } }
$ciVariantCol = hasColumn($pdo,'stock_count_items','variant_id') ? 'variant_id' : null;

// كميات وسياسة التكلفة في items
$ciSysQty  = null; foreach(['system_qty','expected_qty','book_qty','theory_qty'] as $c){ if(hasColumn($pdo,'stock_count_items',$c)){ $ciSysQty=$c; break; } }
$ciCntQty  = null; foreach(['counted_qty','actual_qty','count_qty'] as $c){ if(hasColumn($pdo,'stock_count_items',$c)){ $ciCntQty=$c; break; } }
$ciVarQty  = hasColumn($pdo,'stock_count_items','variance')   ? 'variance'   : (hasColumn($pdo,'stock_count_items','diff_qty') ? 'diff_qty' : null);
$ciUnitCost= null; foreach(['unit_cost','cost','cost_price'] as $c){ if(hasColumn($pdo,'stock_count_items',$c)){ $ciUnitCost=$c; break; } }
$ciLineVal = hasColumn($pdo,'stock_count_items','variance_value') ? 'variance_value' : null;

if (!$ciCountIdCol || !$ciVariantCol) {
  echo '<div class="panel p-3 alert alert-warning">تعذر تحديد أعمدة الربط داخل <code>stock_count_items</code> (مطلوب: count_id/stock_count_id + variant_id).</div>';
  include __DIR__.'/_layout_bottom.php'; exit;
}

/* ========= تحميل قائمة جلسات الجرد (للاختيار) ========= */
$branchMap = branches($pdo); // [BranchID => BranchName]
$scList = [];
$sql = "SELECT sc.id, sc.branch_id"
     . ($scDateCol ? ", sc.`$scDateCol` AS cdate" : "")
     . ($scStatusCol? ", sc.`$scStatusCol` AS st"  : "")
     . ($scNotesCol ? ", sc.`$scNotesCol` AS notes": "")
     . " FROM stock_counts sc ORDER BY sc.id DESC LIMIT 300";
foreach ($pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC) as $r) {
  $labelParts = [];
  $labelParts[] = 'جلسة #' . (int)$r['id'];
  if ($scDateCol) { $labelParts[] = (string)$r['cdate']; }
  $labelParts[] = $branchMap[(int)$r['branch_id']] ?? ('فرع #' . (int)$r['branch_id']);
  if ($scStatusCol && $r['st']!=='') $labelParts[] = '('.$r['st'].')';
  $scList[] = ['id'=>(int)$r['id'], 'label'=>implode(' • ', $labelParts)];
}

/* ========= باراميتر الجلسة ========= */
$count_id = (int)(param('count_id','') ?: 0);

/* ========= جلب تفاصيل الجلسة المحددة ========= */
$header = null; $rows = []; $sumVarQty=0; $sumVarVal=0.0;
if ($count_id > 0) {
  // هيدر الجلسة
  $hsql = "SELECT sc.id, sc.branch_id"
        . ($scDateCol ? ", sc.`$scDateCol` AS cdate" : "")
        . ($scStatusCol? ", sc.`$scStatusCol` AS st"  : "")
        . ($scNotesCol ? ", sc.`$scNotesCol` AS notes": "")
        . " FROM stock_counts sc WHERE sc.id=?";
  $st = $pdo->prepare($hsql); $st->execute([$count_id]); $header = $st->fetch(PDO::FETCH_ASSOC);

  if ($header) {
    // تجهيز اختيار الأعمدة للـ SELECT
    $selectCols = ["i.`$ciVariantCol` AS variant_id"];
    if ($ciSysQty)   $selectCols[] = "i.`$ciSysQty` AS sys_qty";
    if ($ciCntQty)   $selectCols[] = "i.`$ciCntQty` AS cnt_qty";
    if ($ciVarQty)   $selectCols[] = "i.`$ciVarQty` AS var_qty";
    if ($ciUnitCost) $selectCols[] = "i.`$ciUnitCost` AS unit_cost";
    if ($ciLineVal)  $selectCols[] = "i.`$ciLineVal` AS var_val";

    // انضمام بالمنتجات والمتغيرات للعرض
    $join = " JOIN product_variants v ON v.id=i.`$ciVariantCol`"
          . " JOIN products p ON p.id=v.product_id";

    $isql = "SELECT ".implode(',', $selectCols).",
                    v.sku, p.name_ar AS product_name
             FROM stock_count_items i
             $join
             WHERE i.`$ciCountIdCol` = ?
             ORDER BY p.name_ar, v.sku";
    $ist = $pdo->prepare($isql); $ist->execute([$count_id]);
    $rows = $ist->fetchAll(PDO::FETCH_ASSOC);

    // حسبة الفارق والقيمة لو الأعمدة مش موجودة
    foreach ($rows as &$r) {
      $sys = isset($r['sys_qty']) ? (float)$r['sys_qty'] : 0.0;
      $cnt = isset($r['cnt_qty']) ? (float)$r['cnt_qty'] : 0.0;
      if (!isset($r['var_qty']))   $r['var_qty'] = $cnt - $sys;
      if (!isset($r['var_val']))   $r['var_val'] = (isset($r['unit_cost']) ? (float)$r['unit_cost'] : 0.0) * (float)$r['var_qty'];
      $sumVarQty += (float)$r['var_qty'];
      $sumVarVal += (float)$r['var_val'];
    }
    unset($r);
  }
}

/* ========= تصدير CSV ========= */
if (isset($_GET['export']) && $_GET['export']==='csv' && $count_id>0 && $rows) {
  $out = [];
  foreach ($rows as $r) {
    $out[] = [
      'product'   => $r['product_name'] ?? '',
      'sku'       => $r['sku'] ?? '',
      'system'    => $r['sys_qty'] ?? 0,
      'counted'   => $r['cnt_qty'] ?? 0,
      'variance'  => $r['var_qty'] ?? 0,
      'unit_cost' => $r['unit_cost'] ?? 0,
      'impact'    => $r['var_val'] ?? 0,
    ];
  }
  csv_export('stock_count_variance_'.$count_id.'.csv',
             ['product','sku','system','counted','variance','unit_cost','impact'],
             $out);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-8">
      <label class="form-label">جلسة الجرد</label>
      <select class="form-select" name="count_id">
        <option value="">— اختر جلسة —</option>
        <?php foreach($scList as $sc): ?>
          <option value="<?= (int)$sc['id'] ?>" <?= $count_id===$sc['id']?'selected':''; ?>>
            <?= htmlspecialchars($sc['label']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4 d-flex gap-2">
      <button class="btn btn-brand">عرض</button>
      <?php if($count_id>0 && $rows): ?>
        <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
        <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
      <?php endif; ?>
    </div>
  </form>

  <hr>

  <?php if($count_id>0 && $header): ?>
    <div class="alert alert-info">
      <b>جلسة #<?= (int)$header['id'] ?></b> •
      <?= $scDateCol ? 'تاريخ: <b>'.htmlspecialchars($header['cdate']).'</b> • ' : '' ?>
      الفرع: <b><?= htmlspecialchars($branchMap[(int)$header['branch_id']] ?? ('#'.$header['branch_id'])) ?></b>
      <?php if($scStatusCol && $header['st']!==''): ?> • الحالة: <span class="badge bg-secondary"><?= htmlspecialchars($header['st']) ?></span><?php endif; ?>
      <?php if($scNotesCol && $header['notes']): ?><br><small class="text-muted">ملاحظات: <?= nl2br(htmlspecialchars($header['notes'])) ?></small><?php endif; ?>
    </div>

    <div class="table-responsive">
      <table class="table table-striped align-middle text-center">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th class="text-start">الصنف</th>
            <th>SKU</th>
            <?php if($ciSysQty): ?><th>رصيد النظام</th><?php endif; ?>
            <?php if($ciCntQty): ?><th>رصيد فعلي</th><?php endif; ?>
            <th>الفرق</th>
            <?php if($ciUnitCost): ?><th>تكلفة/وحدة</th><?php endif; ?>
            <th>أثر مالي</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows): ?>
            <tr><td colspan="8" class="text-muted">لا توجد بنود لهذه الجلسة.</td></tr>
          <?php else: $i=1; foreach($rows as $r): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td class="text-start"><?= htmlspecialchars($r['product_name'] ?? '-') ?></td>
              <td><?= htmlspecialchars($r['sku'] ?? '-') ?></td>
              <?php if($ciSysQty): ?><td><?= (float)($r['sys_qty'] ?? 0) ?></td><?php endif; ?>
              <?php if($ciCntQty): ?><td><?= (float)($r['cnt_qty'] ?? 0) ?></td><?php endif; ?>
              <td class="<?= ((float)$r['var_qty']??0)!=0 ? 'fw-bold' : '' ?>">
                <?= number_format((float)($r['var_qty'] ?? 0), 2) ?>
              </td>
              <?php if($ciUnitCost): ?><td><?= money((float)($r['unit_cost'] ?? 0)) ?></td><?php endif; ?>
              <td class="<?= ((float)$r['var_val']??0)!=0 ? 'fw-bold' : '' ?>">
                <?= money((float)($r['var_val'] ?? 0)) ?>
              </td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
        <?php if($rows): ?>
        <tfoot class="table-secondary">
          <tr>
            <th colspan="<?= 4 + (int)!!$ciSysQty + (int)!!$ciCntQty + (int)!!$ciUnitCost ?>">الإجماليات</th>
            <th><?= number_format($sumVarQty,2) ?></th>
            <th><?= money($sumVarVal) ?></th>
          </tr>
        </tfoot>
        <?php endif; ?>
      </table>
    </div>
  <?php elseif ($count_id>0): ?>
    <div class="alert alert-warning">لم يتم العثور على جلسة الجرد المحددة.</div>
  <?php else: ?>
    <div class="text-muted">اختر جلسة جرد من القائمة لعرض الفروقات.</div>
  <?php endif; ?>
</div>

<?php include __DIR__.'/_layout_bottom.php';
