<?php
require_once __DIR__ . '/_init.php';
$title='تقييم المخزون (تكلفة)'; include __DIR__ . '/_layout_top.php';
$branch_id = param('branch_id',''); $brs = branches($pdo);

$params=[]; $where=[];
if ($branch_id!==''){ $where[]="s.branch_id=:bid"; $params[':bid']=(int)$branch_id; }
$whereSQL = $where ? 'WHERE '.implode(' AND ',$where):'';

$sql="SELECT b.BranchName,
      SUM(s.quantity * IFNULL(
        (SELECT pi.unit_cost FROM purchase_items pi WHERE pi.variant_id=s.variant_id ORDER BY pi.id DESC LIMIT 1), 0
      )) AS stock_value_cost,
      SUM(s.quantity) AS total_qty
      FROM product_variant_stock s
      LEFT JOIN Branches b ON b.BranchID = s.branch_id
      $whereSQL
      GROUP BY b.BranchName
      ORDER BY stock_value_cost DESC";
$st=$pdo->prepare($sql); $st->execute($params); $rows=$st->fetchAll(PDO::FETCH_ASSOC);
if (isset($_GET['export']) && $_GET['export']==='csv'){
  csv_export('stock_valuation_cost.csv',['BranchName','total_qty','stock_value_cost'],$rows);
}
$total = 0; foreach($rows as $r){ $total += (float)$r['stock_value_cost']; }
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach($brs as $id=>$nm): ?><option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-8 d-flex gap-2">
      <button class="btn btn-brand">تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>">CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()">طباعة</button>
    </div>
  </form><hr>
  <div class="alert alert-info">إجمالي قيمة المخزون بالتكلفة: <strong><?= money($total) ?></strong></div>
  <div class="table-responsive">
    <table class="table table-hover text-center">
      <thead class="table-light"><tr><th>الفرع</th><th>إجمالي الكمية</th><th>قيمة التكلفة</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="3" class="text-muted">لا توجد بيانات.</td></tr>
        <?php else: foreach($rows as $r): ?>
          <tr>
            <td><?= htmlspecialchars($r['BranchName'] ?? '-') ?></td>
            <td><?= (int)$r['total_qty'] ?></td>
            <td class="fw-bold"><?= money($r['stock_value_cost']) ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_bottom.php';
