<?php
require_once __DIR__ . '/_init.php';
$title = 'مصفوفة المقاسات/الألوان';
include __DIR__.'/_layout_top.php';

$brs = branches($pdo);

// اختر عمود الاسم في attributes/attribute_values
$attrNameCol = 'name';
foreach (['name_ar','name_en','name'] as $c) {
  if (hasColumn($pdo,'attributes',$c)) { $attrNameCol = $c; break; }
}
$valNameCol = 'value';
foreach (['value_ar','value_en','value','name_ar','name'] as $c) {
  if (hasColumn($pdo,'attribute_values',$c)) { $valNameCol = $c; break; }
}

// قائمة الخصائص
$attrs = [];
try {
  $attrs = $pdo->query("SELECT id, `$attrNameCol` AS label FROM attributes ORDER BY id")->fetchAll(PDO::FETCH_KEY_PAIR);
} catch (Throwable $e) { $attrs=[]; }

$branch_id = param('branch_id','');
$row_attr  = param('row_attr','');
$col_attr  = param('col_attr','');

// افتراضات لو المستخدم ما اختارش
$attr_ids = array_keys($attrs);
if (!$row_attr && count($attr_ids)>0) $row_attr = $attr_ids[0];
if (!$col_attr && count($attr_ids)>1) $col_attr = $attr_ids[1];

$params = [':row_attr' => (int)$row_attr, ':col_attr'=>(int)$col_attr];
$where = [];
if ($branch_id!==''){ $where[]='s.branch_id=:bid'; $params[':bid']=(int)$branch_id; }
$whereSQL = $where ? 'WHERE '.implode(' AND ', $where) : '';

// نجيب الكميات + قيم الصف/العمود لكل متغير
$sql = "
SELECT
  COALESCE(avr.`$valNameCol`, 'غير محدد') AS row_label,
  COALESCE(avc.`$valNameCol`, 'غير محدد') AS col_label,
  SUM(s.quantity) AS qty
FROM product_variant_stock s
JOIN product_variants v ON v.id = s.variant_id
LEFT JOIN product_variant_values pvr ON pvr.variant_id = v.id
LEFT JOIN attribute_values avr ON avr.id = pvr.attribute_value_id AND avr.attribute_id = :row_attr
LEFT JOIN product_variant_values pvc ON pvc.variant_id = v.id
LEFT JOIN attribute_values avc ON avc.id = pvc.attribute_value_id AND avc.attribute_id = :col_attr
$whereSQL
GROUP BY row_label, col_label
ORDER BY row_label, col_label
";
$st = $pdo->prepare($sql); $st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

// نبني المصفوفة
$rowsSet = []; $colsSet = [];
$grid = [];
foreach ($rows as $r){
  $rl = (string)$r['row_label']; $cl = (string)$r['col_label'];
  $rowsSet[$rl] = true; $colsSet[$cl] = true;
  $grid[$rl][$cl] = (int)$r['qty'];
}
$rowLabels = array_keys($rowsSet); sort($rowLabels, SORT_NATURAL);
$colLabels = array_keys($colsSet); sort($colLabels, SORT_NATURAL);

if (isset($_GET['export']) && $_GET['export']==='csv'){
  // جهّز CSV مسطح
  $headers = array_merge(['\\'], $colLabels);
  $csvRows = [];
  foreach ($rowLabels as $rl){
    $line = ['\\'=> $rl];
    foreach ($colLabels as $cl){ $line[$cl] = (string)($grid[$rl][$cl] ?? 0); }
    $csvRows[] = $line;
  }
  csv_export('variant_matrix.csv', $headers, $csvRows);
}
?>
<div class="panel p-3">
  <form class="row g-2 align-items-end">
    <div class="col-md-3">
      <label class="form-label">الفرع</label>
      <select class="form-select" name="branch_id">
        <option value="">كل الفروع</option>
        <?php foreach ($brs as $id=>$nm): ?>
          <option value="<?= (int)$id ?>" <?= $branch_id!=='' && (int)$branch_id===$id?'selected':''; ?>><?= htmlspecialchars($nm) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">خاصية الصفوف</label>
      <select class="form-select" name="row_attr">
        <?php foreach ($attrs as $id=>$lbl): ?>
          <option value="<?= (int)$id ?>" <?= (string)$row_attr===(string)$id?'selected':''; ?>><?= htmlspecialchars($lbl) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">خاصية الأعمدة</label>
      <select class="form-select" name="col_attr">
        <?php foreach ($attrs as $id=>$lbl): ?>
          <option value="<?= (int)$id ?>" <?= (string)$col_attr===(string)$id?'selected':''; ?>><?= htmlspecialchars($lbl) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex gap-2">
      <button class="btn btn-brand"><i class="fa-solid fa-magnifying-glass"></i> تطبيق</button>
      <a class="btn btn-outline-primary" href="?<?= http_build_query(array_merge($_GET,['export'=>'csv'])) ?>"><i class="fa-solid fa-file-csv"></i> CSV</a>
      <button type="button" class="btn btn-outline-dark" onclick="window.print()"><i class="fa-solid fa-print"></i> طباعة</button>
    </div>
  </form>
  <hr>
  <?php if(!$rowLabels || !$colLabels): ?>
    <div class="alert alert-warning">لا توجد بيانات كافية لتكوين المصفوفة (تحقق من خصائص المتغيرات ووجود مخزون).</div>
  <?php else: ?>
  <div class="table-responsive">
    <table class="table table-bordered text-center align-middle">
      <thead class="table-light">
        <tr>
          <th style="min-width:160px" class="text-start">↘ الصف \ العمود ↗</th>
          <?php foreach ($colLabels as $cl): ?><th><?= htmlspecialchars($cl) ?></th><?php endforeach; ?>
          <th>المجموع</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rowLabels as $rl): $rowSum=0; ?>
          <tr>
            <th class="text-start"><?= htmlspecialchars($rl) ?></th>
            <?php foreach ($colLabels as $cl): $v=(int)($grid[$rl][$cl] ?? 0); $rowSum+=$v; ?>
              <td class="<?= $v===0?'text-muted':'' ?>"><?= $v ?></td>
            <?php endforeach; ?>
            <th><?= $rowSum ?></th>
          </tr>
        <?php endforeach; ?>
      </tbody>
      <tfoot class="table-light">
        <tr>
          <th>المجموع</th>
          <?php $grand=0; foreach($colLabels as $cl){ $colSum=0; foreach($rowLabels as $rl){ $colSum += (int)($grid[$rl][$cl]??0);} $grand+=$colSum; ?>
            <th><?= $colSum ?></th>
          <?php } ?>
          <th><?= $grand ?></th>
        </tr>
      </tfoot>
    </table>
  </div>
  <?php endif; ?>
</div>
<?php include __DIR__.'/_layout_bottom.php';
